# 機能設計書 95-ラベル管理（label）

## 概要

本ドキュメントは、kubectl labelコマンドによるKubernetesリソースへのラベル追加・更新・削除機能の設計を記述する。

### 本機能の処理概要

kubectl labelコマンドは、任意のKubernetesリソースに対してラベル（key/value ペア）を追加・更新・削除するCLI機能である。

**業務上の目的・背景**：ラベルはKubernetesにおけるリソースの論理的なグルーピングやセレクタベースのクエリの基盤となるメタデータである。Service、Deployment、NetworkPolicy等の多くのリソースがラベルセレクタを使用してターゲットリソースを識別する。

**機能の利用シーン**：リソースの分類（env=production, tier=frontend）、セレクタ用ラベルの付与、運用タグの追加（team=backend）、既存ラベルの更新・削除。

**主要な処理内容**：
1. コマンドライン引数からリソースとラベル仕様を解析
2. 対象リソースの取得（Builder パターン）
3. ラベルの追加・更新・削除をMerge Patchで適用
4. 結果の出力

**関連システム・外部連携**：ラベル変更はService/Deployment/ReplicaSet等のセレクタベースリソースに即座に影響する（Podのラベル変更でServiceから外れる等）。

**権限による制御**：対象リソースのupdate/patch権限（RBAC）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | kubectl label | 主機能 | リソースへのラベル追加・更新・削除 |

## 機能種別

CRUD操作（Update） / リソースメタデータ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| TYPE NAME | string | Yes(ファイル未指定時) | リソースタイプと名前 | 有効なリソースタイプ |
| LABEL_SPEC | string[] | Yes | ラベル仕様（key=value / key- / --list） | 有効なラベル形式 |
| --overwrite | bool | No | 既存ラベルの上書き許可 | - |
| --all | bool | No | 指定タイプの全リソースを選択 | - |
| --all-namespaces / -A | bool | No | 全Namespaceを対象 | - |
| --selector / -l | string | No | ラベルセレクタ | 有効なラベルセレクタ形式 |
| --field-selector | string | No | フィールドセレクタ | 有効なフィールドセレクタ形式 |
| --resource-version | string | No | リソースバージョン（楽観ロック） | 単一リソース時のみ |
| --list | bool | No | 現在のラベル一覧を表示 | - |
| --local | bool | No | ローカルモード（API呼び出しなし） | - |
| -f / --filename | string | No | リソース定義ファイル | 有効なファイルパス |
| --dry-run | string | No | dry-run戦略 | none/client/server |

### 入力データソース

CLI引数、ファイル（-fオプション）、kubeconfig

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ラベル操作結果 | string | "resource labeled" メッセージ |
| ラベル一覧 | string | --list時のkey=value一覧 |

### 出力先

標準出力（stdout）

## 処理フロー

### 処理シーケンス

```
1. Complete: コマンド引数と環境の初期化
   └─ namespace、builder、ラベル仕様のパース
2. Validate: 入力パラメータの検証
   └─ --listと--outputの排他チェック
3. RunLabel: ラベル操作実行
   ├─ resource.Builderでリソース取得
   ├─ 各リソースに対して:
   │   ├─ 既存ラベルの上書きチェック
   │   ├─ ラベルの追加・更新・削除
   │   ├─ Merge Patchの生成
   │   └─ API ServerにPATCHリクエスト
   └─ 結果を出力
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-95-01 | 上書き保護 | 既存ラベルの更新は--overwrite必須 | デフォルト |
| BR-95-02 | ラベル形式 | keyはQualifiedName形式、valueはLabelValue形式 | 常時 |
| BR-95-03 | 削除形式 | ラベル削除はkey-形式 | ラベル削除時 |
| BR-95-04 | resource-version排他 | resource-versionは単一リソース時のみ使用可 | 複数リソース指定時は不可 |
| BR-95-05 | listとoutput排他 | --listと--outputは同時指定不可 | - |
| BR-95-06 | allとselector排他 | --allと--selectorは同時指定不可 | - |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Label操作 | 任意のKubernetesリソース | PATCH | metadata.labelsをMerge Patchで更新 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 上書きエラー | 既存ラベル更新時に--overwrite未指定 | --overwriteを指定 |
| - | バリデーションエラー | 無効なラベル形式 | 有効な形式を使用 |
| - | resource-versionエラー | 複数リソースにresource-version指定 | 単一リソースに限定 |
| - | 矛盾エラー | 同一キーの追加と削除を同時指定 | 矛盾を解消 |

## トランザクション仕様

Merge PatchまたはReplace（パッチ生成失敗時のフォールバック）で実行。resource-version指定時は楽観的並行制御。

## パフォーマンス要件

Merge Patchによる軽量操作。--all/--selector使用時はリソース数に比例。

## セキュリティ考慮事項

- 対象リソースのupdate/patch権限が必要
- Podラベルの変更はServiceの到達性に即座に影響する
- セキュリティポリシー関連ラベルの変更は慎重に実施

## 備考

- ラベルキーの最大長は63文字（プレフィックス含めて253文字）
- ラベル値の最大長は63文字
- --listオプションで現在のラベルを一覧表示可能

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | label.go | `staging/src/k8s.io/kubectl/pkg/cmd/label/label.go` | LabelOptions構造体でコマンドの全オプションを確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | label.go | `staging/src/k8s.io/kubectl/pkg/cmd/label/label.go` | NewCmdLabel関数でcobraコマンド定義 |

#### Step 3: ラベル操作処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | label.go | `staging/src/k8s.io/kubectl/pkg/cmd/label/label.go` | RunLabel関数でリソース取得→ラベル更新→PATCH適用の流れ |

**読解のコツ**: label.goの構造はannotate.goと非常に似ている。両者を比較しながら読むと理解が深まる。

### プログラム呼び出し階層図

```
NewCmdLabel
    │
    ├─ Complete
    │      ├─ parseLabels(args)        → newLabels, removeLabels
    │      ├─ f.ToRawKubeConfigLoader().Namespace()
    │      └─ f.NewBuilder()
    │
    ├─ Validate
    │      └─ パラメータ排他チェック
    │
    └─ RunLabel
           ├─ builder.Do() → r.Visit()
           │      └─ 各リソースに対して:
           │             ├─ validateNoLabelOverwrites()
           │             ├─ updateLabels()
           │             ├─ json.Marshal → CreateMergePatch
           │             └─ helper.Patch() / helper.Replace()
           └─ PrintObj()
```

### データフロー図

```
[入力]                       [処理]                      [出力]

CLI引数               ───▶ Complete（初期化）
 (TYPE NAME key=val)         │
                             ▼
kubeconfig            ───▶ RunLabel
                       ├─ Builder.Do()       ───▶ API Server (GET)
                       ├─ updateLabels()
                       ├─ helper.Patch()     ───▶ API Server (PATCH)
                       └─ PrintObj()         ───▶ stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| label.go | `staging/src/k8s.io/kubectl/pkg/cmd/label/label.go` | ソース | labelコマンドのメイン実装 |
