---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：1-API_Serverコア

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：公式ドキュメントとの照合が必要
  2. **エンドポイントリコンサイル間隔**：デフォルト値の正確性要確認
  3. **API Priority and Fairnessの挙動詳細**：429レスポンスのRetry-Afterヘッダーの仕様確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `cmd/kube-apiserver/apiserver.go` - main関数とエントリーポイント
- E-02: `cmd/kube-apiserver/app/server.go` - NewAPIServerCommand関数
- E-03: `pkg/controlplane/instance.go` - Instance構造体、Config構造体、Extra構造体
- E-04: `pkg/controlplane/instance.go` 110-123行目 - DefaultEndpointReconcilerInterval = 10s, TTL = 15s
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.1の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.1に関連する画面マッピング
- E-07: `pkg/controlplane/instance.go` 87-107行目 - RESTストレージプロバイダーインポート
- E-08: `cmd/kube-apiserver/app/server.go` 77-80行目 - kube-apiserverの概要説明
- E-09: `pkg/controlplane/instance.go` 239-253行目 - createEndpointReconciler関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | API Serverはクラスターの中心的コンポーネント | E-08 | ○ |
| C-02 | RESTリクエストを受け付けて認証・認可・アドミッション制御を経てリソースを永続化 | E-05, E-08 | ○ |
| C-03 | main関数でapp.NewAPIServerCommand()を呼び出し | E-01 | ○ |
| C-04 | NewAPIServerCommandがCobraコマンドを生成 | E-02 | ○ |
| C-05 | Instance構造体がControlPlaneサーバーを保持 | E-03 | ○ |
| C-06 | DefaultEndpointReconcilerInterval = 10秒 | E-04 | ○ |
| C-07 | DefaultEndpointReconcilerTTL = 15秒 | E-04 | ○ |
| C-08 | 複数のAPIグループのRESTストレージプロバイダーが登録される | E-07 | ○ |
| C-09 | ServiceIPRange, APIServerServiceIPがExtra構造体で管理 | E-03 | ○ |
| C-10 | リースベースのエンドポイントリコンサイラーがデフォルト | E-09 | ○ |
| C-11 | 関連画面としてkubectl create, expose, run等がAPI連携 | E-06 | ○ |
| C-12 | etcdをストレージバックエンドとして使用 | E-03 | ○ |
| C-13 | 楽観的排他制御にresourceVersionを使用 | E-08 | ○ |
| C-14 | TLS暗号化が必須 | E-02 | ○ |
| C-15 | Watchメカニズムによるリソース変更通知 | E-08 | ○ |
| C-16 | APIグループ・バージョンの管理とAPIディスカバリ | E-07 | ○ |
| C-17 | MasterCountReconciler, LeaseReconciler, NoneReconcilerの3種 | E-09 | ○ |
| C-18 | 認証方式としてx509, token, OIDC, Webhookをサポート | E-02 | ○ |
| C-19 | RBAC, ABAC, Webhookの認可モードをサポート | E-02 | ○ |
| C-20 | ステートレス設計で複数インスタンス起動可能 | E-03, E-09 | ○ |
| C-21 | Finalizerが設定されたリソースは即時削除されずDeletionTimestampが設定 | E-08 | ○ |
| C-22 | ServiceNodePortRangeのデフォルト値が設定される | E-03 | ○ |
| C-23 | APIリクエストのレイテンシ99パーセンタイルで1秒以内 | **根拠なし** | △ |
| C-24 | List操作が大規模クラスターで30秒以内 | **根拠なし** | △ |
| C-25 | 429レスポンスにRetry-Afterヘッダーが含まれる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はKubernetes SLI/SLO公式ドキュメントから取得すべきだが、本リポジトリ内のソースコードからは直接確認できなかった
  - 候補：KEP-0030 / Kubernetes SLI/SLO定義ドキュメント / sig-scalability
- API Priority and FairnessのRetry-Afterヘッダー仕様はapiserver内部のフローコントロール実装を確認する必要がある
  - 候補：`staging/src/k8s.io/apiserver/pkg/util/flowcontrol/` / `pkg/registry/flowcontrol/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードリーディングガイドの行番号とファイルパスは実ソースと一致
- 1: 中リスク - パフォーマンス要件は公式SLOドキュメントとの照合が必要
- 0: 低リスク - 関連画面マッピングはCSVデータと一致

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件の数値がKubernetes SLI/SLO定義と一致しているか確認
- [ ] エンドポイントリコンサイル間隔のデフォルト値（10秒）が最新バージョンで変更されていないか確認
- [ ] API Priority and Fairnessの429レスポンスのRetry-Afterヘッダー仕様を確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
