---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：10-DaemonSetコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **maxSurge/maxUnavailableのデフォルト値**：DaemonSet固有のデフォルト値の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/daemon/daemon_controller.go` 58-80行目 - 定数定義（BurstReplicas=250, StatusUpdateRetries=1, BackoffGCInterval=1分, イベント理由定数）
- E-02: `pkg/controller/daemon/daemon_controller.go` 82-137行目 - controllerKind, DaemonSetsController構造体
- E-03: `pkg/controller/daemon/daemon_controller.go` 139-219行目 - NewDaemonSetsController関数
- E-04: `pkg/controller/daemon/update.go` 44-80行目 - rollingUpdate関数
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.10の定義
- E-06: `pkg/controller/daemon/util/` の存在確認
- E-07: `pkg/controller/daemon/doc.go` の存在確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 全ノードで1つずつPodを実行 | E-05 | ○ |
| C-02 | BurstReplicas = 250 | E-01 | ○ |
| C-03 | StatusUpdateRetries = 1 | E-01 | ○ |
| C-04 | BackoffGCInterval = 1分 | E-01 | ○ |
| C-05 | SelectingAllReason, FailedPlacementReason, FailedDaemonPodReason定数 | E-01 | ○ |
| C-06 | controllerKind = apps.SchemeGroupVersion.WithKind("DaemonSet") | E-02 | ○ |
| C-07 | DaemonSetsController構造体が2つのワークキュー（queue, nodeUpdateQueue）を保持 | E-02 | ○ |
| C-08 | failedPodsBackoffフィールド | E-02 | ○ |
| C-09 | NewDaemonSetsControllerでInformerイベントハンドラ登録 | E-03 | ○ |
| C-10 | DaemonSet, ControllerRevision, Pod, Node用のInformerイベントハンドラ | E-03 | ○ |
| C-11 | podControl, crControlの初期化 | E-03 | ○ |
| C-12 | rollingUpdate関数の存在 | E-04 | ○ |
| C-13 | getNodesToDaemonPodsでノード→Podマッピング取得 | E-04 | ○ |
| C-14 | updatedDesiredNodeCountsでmaxSurge, maxUnavailable計算 | E-04 | ○ |
| C-15 | maxSurge=0の場合の処理分岐（69行目） | E-04 | ○ |
| C-16 | utilディレクトリの存在 | E-06 | ○ |
| C-17 | doc.goの存在 | E-07 | ○ |
| C-18 | ノード変更の専用キュー（nodeUpdateQueue）による分離 | E-02 | ○ |
| C-19 | Pod作成時にnodeNameフィールドを設定 | E-05 | ○ |
| C-20 | maxSurge=0時はmaxUnavailable=1以上必須 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- maxSurge/maxUnavailableのデフォルト値とバリデーションルールはAPI定義から確認すべき
  - 候補：`staging/src/k8s.io/api/apps/v1/types.go` のDaemonSetUpdateStrategy定義、またはバリデーション関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 定数とイベント理由はソースコードと完全一致
- 0: 低リスク - 構造体定義はソースコードと一致
- 0: 低リスク - ローリングアップデートのロジック構造は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] maxSurge/maxUnavailableのデフォルト値とバリデーションルールをAPI定義で確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] shouldRunOnNode判定ロジックの詳細を確認
