---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：100-ファイルコピー（cp）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/cp/cp.go` - cpコマンド実装（592行）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/cp/filespec.go` - ファイルパス抽象化（162行）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.100）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CopyOptionsにContainer, Namespace, NoPreserve, MaxTriesフィールド | E-01（70-83行目） | ○ |
| C-02 | fileSpec構造体はPodName, PodNamespace, Fileで構成 | E-02（25-29行目） | ○ |
| C-03 | localPathはpath/filepath（OS依存）を使用 | E-02（38-69行目） | ○ |
| C-04 | remotePathはpath（UNIX形式）を使用 | E-02（85-123行目） | ○ |
| C-05 | extractFileSpecでfileSpec形式をパース | E-01（170-200行目） | ○ |
| C-06 | 両方リモートの場合はエラー | E-01（247-249行目） | ○ |
| C-07 | 両方ローカルの場合はエラー | E-01（260行目） | ○ |
| C-08 | copyFromPodでTarPipeを使用 | E-01（352-360行目） | ○ |
| C-09 | copyToPodでcheckDestinationIsDir+makeTar+exec | E-01（300-350行目） | ○ |
| C-10 | checkDestinationIsDirは30秒タイムアウト | E-01（283行目） | ○ |
| C-11 | TarPipeでリトライ対応（tail -c+Nで再開） | E-01（396-398行目） | ○ |
| C-12 | untarAllでプレフィックス検証 | E-01（521-523行目） | ○ |
| C-13 | isRelativeでディレクトリトラバーサル防止 | E-01（532-535行目）, E-02（75-81行目） | ○ |
| C-14 | シンボリックリンクはスキップ | E-01（547-557行目） | ○ |
| C-15 | --no-preserveでtar --no-same-permissions --no-same-owner | E-01（326行目） | ○ |
| C-16 | recursiveTarでディレクトリ、シンボリックリンク、通常ファイルを処理 | E-01（433-501行目） | ○ |
| C-17 | execute関数でExecOptionsを設定してリモート実行 | E-01（574-591行目） | ○ |
| C-18 | 機能No.100はファイルコピー | E-03（101行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコード全文を確認済み。セキュリティチェックも網羅

## 6) レビュアーチェックリスト（最小）
- [ ] ディレクトリトラバーサル防止（isRelative, stripPathShortcuts）が十分か確認
- [ ] シンボリックリンクスキップの挙動が適切か確認
- [ ] リトライ機能（TarPipe.Read）のbytesRead計算が正確か確認
- [ ] tarコマンド不在時のエラーハンドリングが適切か確認
