---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：101-リソース差分（diff）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**: 具体的なベンチマーク値の根拠なし

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/diff/diff.go` - メインソースコード
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/diff/prune.go` - プルーニングロジック
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マニフェストとクラスター上リソースの差分をYAMLで表示 | E-01 (53-74行目 diffLong) | ○ |
| C-02 | 終了コード規約（0=差分なし、1=差分あり、2+=エラー） | E-01 (64-73行目) | ○ |
| C-03 | KUBECTL_EXTERNAL_DIFF環境変数で外部diffプログラム指定可能 | E-01 (189-214行目 getCommand) | ○ |
| C-04 | デフォルトdiffは -u -N オプション | E-01 (204-207行目) | ○ |
| C-05 | 最大4回リトライ（maxRetries=4） | E-01 (85行目, 711-748行目) | ○ |
| C-06 | Server-Side Apply対応 | E-01 (350-366行目 Merged関数) | ○ |
| C-07 | Secret値のマスキング（sensitiveMask定数） | E-01 (87-92行目, 444-531行目) | ○ |
| C-08 | managedFieldsのデフォルト除外 | E-01 (576-579行目, 599-607行目) | ○ |
| C-09 | --concurrencyオプションによる並列処理 | E-01 (172行目, 695行目) | ○ |
| C-10 | --pruneオプションによるプルーニング差分 | E-01 (170行目), E-02 | ○ |
| C-11 | 入力はファイルまたはKustomize必須 | E-01 (631行目) | ○ |
| C-12 | --force-conflictsは--server-side時のみ有効 | E-01 (639-641行目) | ○ |
| C-13 | Dry-Runモードで動作（データ変更なし） | E-01 (347-348行目 DryRun(true)) | ○ |
| C-14 | 新規リソースはDry-Run Createで計算 | E-01 (369-377行目) | ○ |
| C-15 | 外部コマンドパラメータの正規表現フィルタリング | E-01 (197行目) | ○ |
| C-16 | 一時ディレクトリを使用した差分比較 | E-01 (286-311行目 Directory構造体) | ○ |
| C-17 | Secretマスキングでbefore/afterの区別 | E-01 (498-511行目) | ○ |
| C-18 | trackerによる訪問済みリソースの追跡 | E-02 (34-44行目, 126-136行目) | ○ |
| C-19 | 画面マッピング: kubectl diff画面No.29 | E-04 (76-77行目) | ○ |
| C-20 | 並列処理数増加でメモリ・CPU使用量が増加 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: パフォーマンスに関する定量的データはソースコード内にコメントがあるが（172行目 "Larger number = faster, but more memory, I/O and CPU"）、具体的なベンチマーク値は不明
  - 候補：パフォーマンステスト結果 / ドキュメント / ベンチマークデータ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能はDry-Runモードで動作するため、クラスターへの実害リスクは低い
- 1: 中リスク - 外部diffコマンドの実行時、環境変数経由のコマンドインジェクションリスク（ただし正規表現フィルタで緩和済み）

## 6) レビュアーチェックリスト（最小）
- [ ] Secret マスキングロジックが全てのSecretタイプに対応しているか確認
- [ ] 外部diffコマンドの引数フィルタリング（正規表現）が十分か確認
- [ ] --prune オプションの動作が apply --prune と整合しているか確認
- [ ] exit code の規約が外部ツール連携（CI/CD）で問題ないか確認
