---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：103-トップ（top）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/top/top.go` - 親コマンド
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_pod.go` - Podメトリクス
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` - Nodeメトリクス
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | node/podサブコマンドを提供 | E-01 (78-79行目) | ○ |
| C-02 | v1beta1のみサポート | E-01 (36-38行目) | ○ |
| C-03 | sort-byはcpu/memoryのみ | E-02 (162-166行目), E-03 (137-141行目) | ○ |
| C-04 | NAMEとselectorの排他チェック | E-02 (167-169行目), E-03 (142-144行目) | ○ |
| C-05 | Pod作成後2分間はメトリクス未取得の可能性 | E-02 (66行目 metricsCreationDelay) | ○ |
| C-06 | Protocol Buffersデフォルト使用 | E-02 (95行目), E-03 (74行目) | ○ |
| C-07 | Allocatable/Capacity選択 | E-03 (198-201行目) | ○ |
| C-08 | スワップ情報表示対応 | E-03 (204-209行目) | ○ |
| C-09 | コンテナ別表示対応 | E-02 (116行目, 222行目) | ○ |
| C-10 | 全Namespace対応 | E-02 (117行目) | ○ |
| C-11 | 合計表示対応 | E-02 (120行目, 222行目) | ○ |
| C-12 | verifyEmptyMetricsでPod年齢チェック | E-02 (252-279行目, 281-290行目) | ○ |
| C-13 | 画面マッピング: kubectl top画面No.14 | E-04 (38-39行目) | ○ |
| C-14 | Metrics APIバージョン確認関数 | E-01 (84-98行目) | ○ |
| C-15 | PodMetricses API使用 | E-02 (233-240行目) | ○ |
| C-16 | NodeMetricses API使用 | E-03 (219-232行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の参照処理

## 6) レビュアーチェックリスト（最小）
- [ ] Metrics Serverが必須である旨のエラーメッセージが適切か確認
- [ ] スワップ情報が利用できないノードへの対応が適切か確認
