---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：104-認証情報確認（auth）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/auth/auth.go` - 親コマンド
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` - can-iソースコード
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/auth/reconcile.go` - reconcileソースコード
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/auth/whoami.go` - whoamiソースコード
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3つのサブコマンド（can-i/reconcile/whoami） | E-01 (36-38行目) | ○ |
| C-02 | can-i: SelfSubjectAccessReview使用 | E-02 (293行目) | ○ |
| C-03 | can-i: 終了コード0=許可、1=拒否 | E-02 (135-138行目) | ○ |
| C-04 | can-i --list: SelfSubjectRulesReview使用 | E-02 (258行目) | ○ |
| C-05 | can-i: 非リソースURLは/で始まる | E-02 (171行目) | ○ |
| C-06 | can-i: リソースVerb一覧 | E-02 (107行目) | ○ |
| C-07 | can-i: 非リソースVerb一覧 | E-02 (108行目) | ○ |
| C-08 | can-i: --list排他制約 | E-02 (212-213行目) | ○ |
| C-09 | can-i: 未知リソースのWarning出力 | E-02 (329-332行目) | ○ |
| C-10 | can-i: 未知VerbのWarning出力 | E-02 (230-231行目, 240-241行目) | ○ |
| C-11 | can-i: Namespaceスコープチェック | E-02 (232-239行目) | ○ |
| C-12 | can-i: 非標準リソース名（users/groups）の例外 | E-02 (110行目, 327行目) | ○ |
| C-13 | reconcile: rbac/v1のみサポート | E-03 (295-303行目) | ○ |
| C-14 | reconcile: コンフリクト最大3回リトライ | E-03 (203行目) | ○ |
| C-15 | reconcile: Role/ClusterRole/RoleBinding/ClusterRoleBinding対応 | E-03 (210-293行目) | ○ |
| C-16 | reconcile: --remove-extra-permissions / --remove-extra-subjects | E-03 (110-111行目) | ○ |
| C-17 | reconcile: server-side dry-run不可 | E-03 (372-374行目) | ○ |
| C-18 | reconcile: autoupdateアノテーションopt-out | E-03 (323-325行目) | ○ |
| C-19 | whoami: v1->v1beta1->v1alpha1フォールバック | E-04 (175-188行目) | ○ |
| C-20 | whoami: Username/UID/Groups/Extra表示 | E-04 (230-261行目) | ○ |
| C-21 | whoami: Experimentalステータス | E-04 (122行目) | ○ |
| C-22 | 画面マッピング: 画面No.35/36/37 | E-05 (80-85行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - can-i/whoamiは読み取り専用
- 1: 中リスク - reconcileはRBACリソースを変更するため、意図しない権限変更のリスク

## 6) レビュアーチェックリスト（最小）
- [ ] reconcileのコンフリクトリトライが適切に動作するか確認
- [ ] whoami APIのフォールバックが全バージョンで正しく動作するか確認
- [ ] can-i --list の結果が不完全な場合のWarning表示を確認
