---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：105-証明書管理（certificates）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` - メインソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | approve/denyの2サブコマンド提供 | E-01 (55-56行目) | ○ |
| C-02 | certificates.k8s.io/v1のみサポート | E-01 (238行目 certificatesV1Client) | ○ |
| C-03 | Approved CSRにDeny試行でエラー | E-01 (283-286行目) | ○ |
| C-04 | 冪等性: 同一条件CSRはスキップ | E-01 (291-293行目) | ○ |
| C-05 | コンフリクト最大10回リトライ | E-01 (257行目 i < 10) | ○ |
| C-06 | UpdateApproval API使用 | E-01 (252行目) | ○ |
| C-07 | Approve条件メッセージ | E-01 (166-167行目) | ○ |
| C-08 | Deny条件メッセージ | E-01 (209行目) | ○ |
| C-09 | KubectlApprove/KubectlDeny理由 | E-01 (166-167行目, 209行目) | ○ |
| C-10 | --force で強制更新 | E-01 (149行目, 250行目) | ○ |
| C-11 | LastUpdateTime自動設定 | E-01 (299行目 metav1.Now()) | ○ |
| C-12 | 1つ以上のCSR指定必須 | E-01 (116-118行目) | ○ |
| C-13 | GVKチェック: CSRオブジェクトのみ | E-01 (233-235行目) | ○ |
| C-14 | セキュリティ通知（LongDesc内） | E-01 (130-141行目) | ○ |
| C-15 | 未検出時 "No resources found" | E-01 (273-275行目) | ○ |
| C-16 | 画面マッピング: 画面No.38/39 | E-03 (86-89行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - CSR承認は証明書発行に直結するため、セキュリティ上最も重要な操作の一つ

## 6) レビュアーチェックリスト（最小）
- [ ] approve権限の制限が適切に設定されているか確認
- [ ] --forceフラグの使用が監査ログに記録されるか確認
- [ ] コンフリクトリトライが無限ループにならないことを確認
