---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：107-リソース置換（replace）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/replace/replace.go` - メインソースコード
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PUT APIでリソース完全置換 | E-01 (305行目 Replace) | ○ |
| C-02 | --force: 削除+再作成の2段階操作 | E-01 (315-423行目) | ○ |
| C-03 | grace-period=0 を自動的に1に変換 | E-01 (186-189行目) | ○ |
| C-04 | --forceデフォルトタイムアウト5分 | E-01 (355-357行目) | ○ |
| C-05 | 削除待機1秒間隔ポーリング | E-01 (362行目) | ○ |
| C-06 | stdinテンポラリファイル保存 | E-01 (317-332行目) | ○ |
| C-07 | --force + --dry-run 排他 | E-01 (224-226行目) | ○ |
| C-08 | --grace-period は --force 必須 | E-01 (216-218行目) | ○ |
| C-09 | --timeout は --force 必須 | E-01 (220-222行目) | ○ |
| C-10 | --raw は単一ファイルのみ | E-01 (233-234行目) | ○ |
| C-11 | --raw はURL不可 | E-01 (236-238行目) | ○ |
| C-12 | --raw と --recursive 排他 | E-01 (239-241行目) | ○ |
| C-13 | --raw と --output 排他 | E-01 (242-244行目) | ○ |
| C-14 | ファイル必須チェック | E-01 (228-230行目) | ○ |
| C-15 | IgnoreNotFound = true（削除時） | E-01 (181行目) | ○ |
| C-16 | フィールドマネージャー デフォルト "kubectl-replace" | E-01 (136行目) | ○ |
| C-17 | CreateOrUpdateAnnotation処理 | E-01 (286行目) | ○ |
| C-18 | 画面マッピング: 画面No.25 | E-03 (60-61行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - --force使用時にリソースのダウンタイムが発生する
- 1: 中リスク - 通常replaceでもフィールドが消失する可能性がある（PUT = 完全置換）

## 6) レビュアーチェックリスト（最小）
- [ ] --force使用時のダウンタイムが許容される環境でのみ使用されているか確認
- [ ] grace-period=0 -> 1 の自動変換がドキュメントに記載されているか確認
- [ ] stdinテンポラリファイルのクリーンアップが確実に行われるか確認
