---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：108-クラスター情報（cluster-info）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` - cluster-infoソース
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` - dumpソース
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cluster-service=true ラベルでフィルタ | E-01 (99行目) | ○ |
| C-02 | デフォルトNamespace: kube-system | E-01 (85-87行目) | ○ |
| C-03 | コントロールプレーンURL出力 | E-01 (106行目) | ○ |
| C-04 | LoadBalancer Ingress URL計算 | E-01 (111-119行目) | ○ |
| C-05 | API Proxy URL計算 | E-01 (120-141行目) | ○ |
| C-06 | https推定（ポート名/番号） | E-01 (128-129行目) | ○ |
| C-07 | kubernetes.io/name ラベルによるサービス名解決 | E-01 (143-146行目) | ○ |
| C-08 | dump案内メッセージ | E-01 (151行目) | ○ |
| C-09 | dump: JSON デフォルト出力 | E-02 (69行目 WithDefaultOutput("json")) | ○ |
| C-10 | dump: Podログタイムアウト20秒 | E-02 (44行目 defaultPodLogsTimeout) | ○ |
| C-11 | dump: ディレクトリ出力オプション | E-02 (53行目 OutputDir) | ○ |
| C-12 | dump: 全Namespace対応 | E-02 (54行目 AllNamespaces) | ○ |
| C-13 | utilnet.JoinSchemeNamePort使用 | E-01 (133行目) | ○ |
| C-14 | printService関数 | E-01 (157-162行目) | ○ |
| C-15 | 画面マッピング: 画面No.30/31 | E-03 (70-73行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の情報表示
- 1: 中リスク - dump出力にクラスター内の広範な情報が含まれるため、出力ファイルの管理に注意

## 6) レビュアーチェックリスト（最小）
- [ ] dump出力に機密情報（Secretのデータ等）が含まれないか確認
- [ ] 大規模クラスターでのdump実行時間が許容範囲内か確認
