---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：110-explain

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **CRD OpenAPI Validation Schema**: CRDフィールド説明の動作条件の根拠が外部ドキュメント依存

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/explain/explain.go` - メインソースコード
- E-02: `staging/src/k8s.io/kubectl/pkg/explain/` - V2スキーマ解析パッケージ
- E-03: `staging/src/k8s.io/kubectl/pkg/explain/v2/` - V3スキーマ解析パッケージ
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenAPI V3優先、V2フォールバック | E-01 (200-210行目) | ○ |
| C-02 | plaintext/plaintext-openapiv2 出力形式 | E-01 (64-67行目) | ○ |
| C-03 | TYPE引数1つのみ必須 | E-01 (168-177行目) | ○ |
| C-04 | "." 区切りでフィールドパス分離 | E-01 (185-197行目) | ○ |
| C-05 | --api-version でバージョン指定 | E-01 (91行目, 212-219行目) | ○ |
| C-06 | --recursive で再帰表示 | E-01 (90行目, 227行目) | ○ |
| C-07 | RESTMapperによるGVR解決 | E-01 (97-100行目, 185行目) | ○ |
| C-08 | V3: PrintModelDescription呼び出し | E-01 (221-228行目) | ○ |
| C-09 | V2: openAPIGetter.OpenAPISchema() | E-01 (254行目) | ○ |
| C-10 | V2: LookupResource | E-01 (258行目) | ○ |
| C-11 | V3未対応時のフォールバック | E-01 (205-208行目) | ○ |
| C-12 | --api-version未指定時のMatchingPrefix | E-01 (185行目) | ○ |
| C-13 | 再帰レベル1のみ | E-01 (90行目 "Currently only 1 level deep") | ○ |
| C-14 | ExplainFlags -> ExplainOptions 変換パターン | E-01 (72-78行目, 96-125行目, 150-166行目) | ○ |
| C-15 | 画面マッピング: 画面No.34 | E-04 (78-79行目) | ○ |
| C-16 | CRDフィールド説明はOpenAPI Validation Schema必須 | **根拠なし（外部ドキュメント依存）** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: CRDのOpenAPI Validation SchemaがexplainコマンドのCRDフィールド説明に必要という情報は、Kubernetes公式ドキュメントに記載されているが、ソースコード内では直接確認できない
  - 候補：Kubernetes公式ドキュメント / CRD仕様 / OpenAPIスキーマ生成ロジック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のスキーマ表示

## 6) レビュアーチェックリスト（最小）
- [ ] V3 -> V2 フォールバックが透過的に動作するか確認
- [ ] CRDリソースのexplain出力が期待通りか確認
- [ ] --api-version指定時のバージョン解決が正しいか確認
