---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：113-kubectl-convert

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `cmd/kubectl-convert/kubectl-convert.go` - エントリーポイント
- E-02: `pkg/kubectl/cmd/convert/convert.go` - 変換ロジック
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.113）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 独立バイナリとして提供 | E-01 (main関数) | ○ |
| C-02 | --localデフォルトtrue | E-02 (83行目) | ○ |
| C-03 | legacyschemeで変換 | E-02 (143行目, 182行目) | ○ |
| C-04 | tryConvertで順次バージョン変換 | E-02 (284-298行目) | ○ |
| C-05 | デフォルト出力形式はYAML | E-02 (82行目) | ○ |
| C-06 | 複数リソースはList形式で出力 | E-02 (205-218行目) | ○ |
| C-07 | ファイル必須 | E-02 (116-117行目) | ○ |
| C-08 | 未登録型はJSON Raw形式 | E-02 (245-254行目) | ○ |
| C-09 | 入力0件でエラー | E-02 (170-172行目) | ○ |
| C-10 | --output-versionでGroupVersion指定 | E-02 (106行目, 175-180行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードの根拠がある

## 6) レビュアーチェックリスト（最小）
- [ ] import_known_versions.goの内容が設計書に影響する情報を含んでいないか確認
- [ ] kubectl本体との分離がドキュメントで正確に説明されているか
