---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：119-ノード参加（join）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **各フェーズの詳細処理**：フェーズ実装は個別ファイルにあり未詳述

## 2) 参照した情報（Evidence一覧）

- E-01: `cmd/kubeadm/app/cmd/join.go` - joinコマンドの全実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.119）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 8フェーズのワークフロー | E-01 (222-229行目) | ○ |
| C-02 | Discovery方式（トークン/ファイル） | E-01 (85-128行目, joinLongDescription) | ○ |
| C-03 | --tokenの兼用ロジック | E-01 (363-370行目) | ○ |
| C-04 | --control-planeフラグ未指定時の警告 | E-01 (400-404行目) | ○ |
| C-05 | admin.conf存在時のDiscoveryスキップ | E-01 (411-418行目) | ○ |
| C-06 | ワーカー参加メッセージ | E-01 (57-64行目) | ○ |
| C-07 | コントロールプレーン参加メッセージ | E-01 (66-83行目) | ○ |
| C-08 | CA検証スキップのセキュリティリスク | E-01 (115-117行目) | ○ |
| C-09 | HTTPS必須（Discovery URL） | E-01 (100-101行目) | ○ |
| C-10 | joinData.InitCfg()のDiscovery実行 | E-01 (560-579行目) | ○ |
| C-11 | fetchInitConfiguration | E-01 (714-724行目) | ○ |
| C-12 | DryRunのdryRunDir使用 | E-01 (469-474行目) | ○ |
| C-13 | DiscoveryFileとBootstrapTokenの排他処理 | E-01 (373-385行目) | ○ |
| C-14 | 各フェーズの具体的な処理内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 各フェーズの詳細処理は`cmd/kubeadm/app/cmd/phases/join/`配下に実装
  - 候補：preflight.go / controlplaneprepare.go / kubeletstart.go 等

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Discovery/TLSブートストラップのセキュリティモデルが正確に記述されているか確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 8フェーズの順序と名称が正確か
- [ ] Discoveryプロセスの説明が正確か
- [ ] セキュリティモデル（双方向信頼）の説明が十分か
