---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-CronJobコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **デフォルトワーカー数**：コード外での設定値のため直接確認困難

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/controller/cronjob/cronjob_controllerv2.go` - ControllerV2メインロジック
- E-02: `pkg/controller/cronjob/utils.go` - スケジュール計算ユーティリティ
- E-03: `pkg/controller/cronjob/injection.go` - Job/CronJob操作インターフェース
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.12 CronJob定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CronスケジュールでJobを定期作成 | E-01, E-04 | ○ |
| C-02 | ControllerV2構造体定義（63-81行目） | E-01 | ○ |
| C-03 | NewControllerV2（84-131行目） | E-01 | ○ |
| C-04 | Run関数（134-162行目） | E-01 | ○ |
| C-05 | sync関数（188-235行目） | E-01 | ○ |
| C-06 | syncCronJob関数（426-674行目） | E-01 | ○ |
| C-07 | cleanupFinishedJobs（682-716行目） | E-01 | ○ |
| C-08 | ConcurrencyPolicy: Allow/Forbid/Replace | E-01 | ○ |
| C-09 | nextScheduleDelta = 100ms | E-01 | ○ |
| C-10 | StartingDeadlineSecondsによるスキップ | E-01 | ○ |
| C-11 | タイムゾーン対応 | E-01 | ○ |
| C-12 | Job名の生成ルール | E-01 | ○ |
| C-13 | CRON_TZ/TZの警告 | E-01 | ○ |
| C-14 | CronJobCreationSkewメトリクス | E-01 | ○ |
| C-15 | AlreadyExistsハンドリング | E-01 | ○ |
| C-16 | removeOldestJobs | E-01 | ○ |
| C-17 | OwnerReferenceによるカスケード削除 | E-01 | ○ |
| C-18 | デフォルトワーカー数5 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: ワーカー数はcmd/kube-controller-managerの設定で指定される。コントローラーコード内にはデフォルト値は含まれない。
  - 候補：`cmd/kube-controller-manager/` / controller-manager設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: utils.goのnextScheduleTime/getJobFromTemplate2の詳細は省略されている
- 0: CronJobV1からV2への移行に関する背景情報の不足

## 6) レビュアーチェックリスト（最小）
- [ ] ConcurrencyPolicyの3パターンの動作説明が正確か
- [ ] StartingDeadlineSecondsの計算ロジックが正確か
- [ ] タイムゾーン処理の説明が十分か
