---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：120-クラスターアップグレード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **各フェーズの詳細処理**：フェーズ実装は個別ファイルにあり未詳述
  2. **diff/nodeサブコマンドの詳細**：主要ファイルのみ確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `cmd/kubeadm/app/cmd/upgrade/upgrade.go` - upgradeコマンドのルート
- E-02: `cmd/kubeadm/app/cmd/upgrade/apply.go` - upgrade applyの実装
- E-03: `cmd/kubeadm/app/cmd/upgrade/plan.go` - upgrade planの実装
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.120）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4サブコマンド（apply/plan/diff/node） | E-01 (62-65行目) | ○ |
| C-02 | 共通フラグ（applyPlanFlags） | E-01 (31-41行目, 69-78行目) | ○ |
| C-03 | applyData構造体のフィールド | E-02 (62-78行目) | ○ |
| C-04 | 8フェーズの登録（apply） | E-02 (132-139行目) | ○ |
| C-05 | バージョン引数の必須性とオーバーライド | E-02 (171-182行目) | ○ |
| C-06 | 対話モード制御 | E-02 (346-348行目) | ○ |
| C-07 | --certificate-renewalデフォルトtrue | E-02 (85行目) | ○ |
| C-08 | --etcd-upgradeデフォルトtrue | E-01 (52行目) | ○ |
| C-09 | ConfigMap不在エラー | E-02 (246-250行目) | ○ |
| C-10 | genUpgradePlanのコンポーネント一覧 | E-03 (151-233行目) | ○ |
| C-11 | upgradePlanTextPrinterの出力形式 | E-03 (262-391行目) | ○ |
| C-12 | runPlanのフロー | E-03 (100-148行目) | ○ |
| C-13 | ValueFromFlagsOrConfigパターン | E-02 (189-231行目) | ○ |
| C-14 | 各applyフェーズの具体的処理 | **根拠なし** | △ |
| C-15 | diff/nodeサブコマンドの詳細処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- apply用フェーズの詳細は`cmd/kubeadm/app/cmd/phases/upgrade/apply/`に実装
  - 候補：preflight.go / controlplane.go / uploadconfig.go / kubeconfig.go
- diff/nodeサブコマンドの詳細は`cmd/kubeadm/app/cmd/upgrade/diff.go`と`node.go`に実装

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - アップグレード処理はクラスターに大きな影響を与えるため、フェーズ詳細の確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 8フェーズの順序と名称が正確か
- [ ] バージョンオーバーライドの動作が正確か
- [ ] ComponentConfig状態表示のカラムが正確か
- [ ] diff/nodeサブコマンドの説明を追加するか検討
