---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：121-証明書管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **renewalパッケージの内部詳細**：renewal/ディレクトリの内部実装は直接読み込んでいない
  2. **パフォーマンス要件の数値**：「数秒以内」の根拠が不明確

## 2) 参照した情報（Evidence一覧）

- E-01: `cmd/kubeadm/app/cmd/certs.go` - CLIコマンド定義
- E-02: `cmd/kubeadm/app/phases/certs/certs.go` - PKI作成・検証ロジック
- E-03: `cmd/kubeadm/app/phases/certs/certlist.go` - 証明書定義リストとツリー構造
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kubeadm certsは4つのサブコマンド（renew、check-expiration、generate-csr、certificate-key）を持つ | E-01 (104-117行目) | ○ |
| C-02 | PKI作成時にetcdのローカル/外部で証明書リストが分岐する | E-02 (53-57行目) | ○ |
| C-03 | GetDefaultCertListは10種類の証明書を定義する | E-03 (249-264行目) | ○ |
| C-04 | 外部CA検出はCA証明書存在+CA鍵不在で判定する | E-02 (294-314行目) | ○ |
| C-05 | renewは有効期限に関係なく無条件で実行される | E-01 (57-60行目) | ○ |
| C-06 | renewCertはローカルCAを使用して更新する | E-01 (320-344行目) | ○ |
| C-07 | 証明書のNotBeforeはバックデートされる | E-03 (73行目) | ○ |
| C-08 | 有効期間はClusterConfigurationのvalidityPeriodに従う | E-03 (78-87行目) | ○ |
| C-09 | 暗号化アルゴリズムはClusterConfigurationに従う | E-03 (90行目) | ○ |
| C-10 | check-expirationはテキストとJSON出力をサポートする | E-01 (441, 497-547行目) | ○ |
| C-11 | generate-csrは鍵とCSRファイルを生成する | E-03 (478-524行目) | ○ |
| C-12 | certificate-keyはcopycerts.CreateCertificateKeyを呼び出す | E-01 (202-209行目) | ○ |
| C-13 | 既存証明書が有効ならスキップする（冪等性） | E-02 (173-204行目) | ○ |
| C-14 | SA鍵ペアはPKI作成の最後に生成される | E-02 (71行目) | ○ |
| C-15 | writeCertificateFilesIfNotExistは署名検証とSAN検証を行う | E-02 (210-252行目) | ○ |
| C-16 | CheckCertificatePeriodValidityはキャッシュで重複チェックを防ぐ | E-02 (464-476行目) | ○ |
| C-17 | CertTreeはCA→リーフ証明書の1レベルツリーを構築する | E-03 (144-145行目, 215-233行目) | ○ |
| C-18 | getInternalCfgはConfigMap→ファイル→デフォルトの順でフォールバックする | E-01 (346-373行目) | ○ |
| C-19 | SharedCertificateExistsは共有証明書の検証を行う | E-02 (264-288行目) | ○ |
| C-20 | 関連画面マッピングが正確である | E-05 | ○ |
| C-21 | 機能一覧の説明と一致する | E-04 | ○ |
| C-22 | CreateFromCAはGetConfig→NewCertAndKey→writeの順で処理する | E-03 (95-118行目) | ○ |
| C-23 | configMutatorsでAltNames等を動的設定する | E-03 (59-64行目, 446-455行目) | ○ |
| C-24 | renewal.Managerの内部実装詳細 | **根拠なし** | △ |
| C-25 | パフォーマンスは「数秒以内」である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- renewal/ディレクトリの実装を直接読み込んでいないため、RenewUsingLocalCAの内部処理の詳細は未検証
  - 候補：`cmd/kubeadm/app/phases/certs/renewal/manager.go` / `renewal/readwriter.go`
- パフォーマンスの「数秒以内」は一般的な知識に基づく推定であり、ベンチマーク等の根拠がない

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 証明書リストの網羅性（ソースコードから直接確認可能）
- 0: 低リスク - CLIパラメータの説明（ソースコードから直接確認可能）
- 1: 中リスク - renewal内部処理の詳細が未検証

## 6) レビュアーチェックリスト（最小）
- [ ] renewal/ディレクトリのRenewUsingLocalCAの実装が設計書の記述と一致するか確認
- [ ] パフォーマンス要件の記述が運用実態と整合するか確認
- [ ] 外部CAモードの動作記述が実際の動作と一致するか確認
