---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：122-CSIボリューム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **csi_plugin.goのInit処理詳細**：プラグイン全体のファイルは概要のみ確認

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/volume/csi/csi_mounter.go` - マウント/アンマウント処理
- E-02: `pkg/volume/csi/csi_plugin.go` - プラグイン登録・管理
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | csiMountMgr構造体がMounter/Unmounterを実装 | E-01 (82, 96, 427行目) | ○ |
| C-02 | SetUpAtはEphemeral/Persistentで分岐処理する | E-01 (146-208行目) | ○ |
| C-03 | vol_data.jsonにspecVolID等のメタデータを保存する | E-01 (277-284行目) | ○ |
| C-04 | NodePublishVolume RPCを呼び出す | E-01 (300-313行目) | ○ |
| C-05 | TransientOperationFailureでCSIドライバー不在時エラーを返す | E-01 (107-110行目) | ○ |
| C-06 | VolumeLifecycleMode検証を行う | E-01 (531-559行目) | ○ |
| C-07 | FSGroupPolicyに基づくFSGroup適用判定を行う | E-01 (469-500, 504-527行目) | ○ |
| C-08 | VOLUME_MOUNT_GROUPcapabilityでFSGroup委任する | E-01 (250-260行目) | ○ |
| C-09 | EphemeralボリュームのvolumeHandleはSHA256で生成 | E-01 (612-615行目) | ○ |
| C-10 | TearDownAtでNodeUnpublishVolume RPCを呼び出す | E-01 (447-449行目) | ○ |
| C-11 | removeMountDirでマウントポイントとメタデータを削除 | E-01 (583-609行目) | ○ |
| C-12 | podInfoEnabled時にPod情報をvolume_attributesに注入 | E-01 (228-234行目) | ○ |
| C-13 | ServiceAccountトークンをTokenRequest APIで取得 | E-01 (358-416行目) | ○ |
| C-14 | ServiceAccountTokenInSecrets対応 | E-01 (244-248行目) | ○ |
| C-15 | SELinuxMountReadWriteOncePod対応 | E-01 (262-272行目) | ○ |
| C-16 | マウント失敗時にマウントディレクトリを削除する | E-01 (315-323行目) | ○ |
| C-17 | FSGroup適用失敗時にUncertainProgressErrorを返す | E-01 (349行目) | ○ |
| C-18 | vol_data.json書き込み後のエラー時もディレクトリ削除 | E-01 (290-298行目) | ○ |
| C-19 | getSourceFromSpecでボリュームソースを判定 | E-01 (115-118行目) | ○ |
| C-20 | csi_plugin.goのInit詳細処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- csi_plugin.goの全体を読み込んでいるが、Init()の完全な処理フロー（ドライバー登録、レジストリ連携）の詳細記述が不足
  - 候補：`pkg/volume/csi/csi_plugin.go` の Init()、RegistrationHandler

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - SetUpAt/TearDownAtの処理フロー（ソースコードから直接確認済み）
- 0: 低リスク - vol_data.jsonのフォーマット（ソースコードから直接確認済み）
- 1: 中リスク - csi_client.goのgRPC通信詳細は未精査

## 6) レビュアーチェックリスト（最小）
- [ ] csi_plugin.goのInit()処理がプラグイン登録フローの記述と一致するか確認
- [ ] csi_client.goのgRPC通信仕様が設計書の記述と整合するか確認
- [ ] NodeStageVolume/NodeUnstageVolumeの処理フローが網羅されているか確認
