---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：124-EmptyDirボリューム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/volume/emptydir/empty_dir.go` - EmptyDirプラグイン全コード（585行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ディレクトリパーミッションは0777 | E-01 (50行目: `const perm os.FileMode = 0777`) | ○ |
| C-02 | 3種類のmedium（Default/Memory/HugePages）をサポート | E-01 (266-275行目) | ○ |
| C-03 | tmpfsサイズ制限はmin(sizeLimit, podLimit, nodeAllocatable) | E-01 (114-140行目) | ○ |
| C-04 | readyマーカーで冪等性を実現 | E-01 (247-264行目) | ○ |
| C-05 | setupTmpfsでMountSensitiveWithoutSystemdを呼び出す | E-01 (339行目) | ○ |
| C-06 | setupHugepagesでhugetlbfsをマウントする | E-01 (384行目) | ○ |
| C-07 | getPageSizeMountOptionでHugePagesページサイズを特定 | E-01 (389-445行目) | ○ |
| C-08 | Hugepagesで複数ページサイズはエラー | E-01 (425-427行目) | ○ |
| C-09 | TearDownAtでmediumを再判定してティアダウン分岐 | E-01 (510-524行目) | ○ |
| C-10 | teardownDefaultでfsquota.ClearQuotaを呼び出す | E-01 (528-534行目) | ○ |
| C-11 | teardownTmpfsOrHugetlbfsでUnmount後にRemoveAll | E-01 (544-555行目) | ○ |
| C-12 | assignQuotaでfsquota.SupportsQuotasを確認 | E-01 (291-315行目) | ○ |
| C-13 | generateTmpfsMountOptionsでsizeとnoswapを設定 | E-01 (573-584行目) | ○ |
| C-14 | RequiresRemountはfalse | E-01 (98-100行目) | ○ |
| C-15 | FSGroup権限適用にNewVolumeOwnershipを使用 | E-01 (277-278行目) | ○ |
| C-16 | newMounterInternalでMediumMemory時にサイズ計算 | E-01 (142-165行目) | ○ |
| C-17 | ConstructVolumeSpecでEmptyDirのVolumeSpecを構築 | E-01 (185-195行目) | ○ |
| C-18 | PodLevelResourcesフィーチャーゲート対応 | E-01 (404-406行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（メインソースファイル全体を読み込み済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全コードを読み込み済み
- 0: 低リスク - Linux固有実装（empty_dir_linux.go）は設計概要として影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] empty_dir_linux.goのrealMountDetector実装がGetMountMediumの記述と一致するか確認
- [ ] fsquotaパッケージのSupportsQuotas/AssignQuotaの挙動が記述と一致するか確認
