---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：128-Projectedボリューム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/volume/projected/projected.go` - Projectedプラグイン全コード（466行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 6種類のソースタイプ（Secret、ConfigMap、DownwardAPI、SAToken、CTB、PodCert） | E-01 (259-428行目) | ○ |
| C-02 | ReadOnly=true、Managed=true、SELinuxRelabel=true | E-01 (173-180行目) | ○ |
| C-03 | wrappedVolumeSpecでStorageMediumMemory指定 | E-01 (59-67行目) | ○ |
| C-04 | RequiresRemount=true | E-01 (100-102行目) | ○ |
| C-05 | collectDataで全ソースのデータを収集 | E-01 (247-431行目) | ○ |
| C-06 | Secretソース: secret.MakePayload呼び出し | E-01 (277行目) | ○ |
| C-07 | ConfigMapソース: configmap.MakePayload呼び出し | E-01 (302行目) | ○ |
| C-08 | DownwardAPIソース: downwardapi.CollectData呼び出し | E-01 (312行目) | ○ |
| C-09 | SAトークン: TokenRequest APIでBoundObjectRef付きトークン取得 | E-01 (334-345行目) | ○ |
| C-10 | SAトークンのパーミッションはFsUser/FsGroup設定時に0600 | E-01 (326-328行目) | ○ |
| C-11 | CTB: nameまたはsignerNameで取得 | E-01 (362-379行目) | ○ |
| C-12 | CTB: nameもsignerNameもない場合はエラー | E-01 (377行目) | ○ |
| C-13 | PodCertificate: 3つのパス（credentialBundle/key/certificateChain）をサポート | E-01 (403-426行目) | ○ |
| C-14 | エラー集約にutilerrors.NewAggregate使用 | E-01 (430行目) | ○ |
| C-15 | TearDown時にdeleteServiceAccountToken呼び出し | E-01 (454行目) | ○ |
| C-16 | wrappedUnmounterでEmptyDirを通じてTearDown | E-01 (446-452行目) | ○ |
| C-17 | Init()で6種類のgetter関数を設定 | E-01 (73-81行目) | ○ |
| C-18 | セットアップ失敗時にdeferでTearDown | E-01 (209-222行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全コードを読み込み済み

## 6) レビュアーチェックリスト（最小）
- [ ] PodCertificateソースの実装がAPI仕様と一致するか確認
- [ ] ClusterTrustBundleのlabelSelector処理が正確か確認
