---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：130-NFSボリューム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/volume/nfs/nfs.go` - NFSプラグイン全コード（312行）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VolumePlugin、PersistentVolumePlugin、RecyclableVolumePluginを実装 | E-01 (61-63行目) | ○ |
| C-02 | IsNotMountPointで冪等性を実現 | E-01 (227-234行目) | ○ |
| C-03 | MkdirAll 0750でディレクトリ作成 | E-01 (235-237行目) | ○ |
| C-04 | server:path形式でマウントソース構築 | E-01 (238行目) | ○ |
| C-05 | readOnly時に"ro"オプション追加 | E-01 (240-242行目) | ○ |
| C-06 | MountSensitiveWithoutSystemd("nfs")で呼び出し | E-01 (244行目) | ○ |
| C-07 | マウント失敗時のクリーンアップ処理 | E-01 (245-269行目) | ○ |
| C-08 | TearDownAtでForce Unmount対応 | E-01 (287-290行目) | ○ |
| C-09 | extensiveMountPointCheck=true使用 | E-01 (290, 292行目) | ○ |
| C-10 | unMountTimeout=1分 | E-01 (67-68行目) | ○ |
| C-11 | IPv6アドレスのブラケット表記 | E-01 (306-311行目) | ○ |
| C-12 | GetAccessModesでRWO/ROX/RWX | E-01 (108-114行目) | ○ |
| C-13 | SupportsMountOption=true | E-01 (100-102行目) | ○ |
| C-14 | Managed=false、SELinuxRelabel=false | E-01 (213-219行目) | ○ |
| C-15 | Recycle: リサイクルPod起動 | E-01 (156-173行目) | ○ |
| C-16 | MetricsStatFS使用 | E-01 (131行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全コードを読み込み済み

## 6) レビュアーチェックリスト（最小）
- [ ] NFSマウントオプション（nfsvers等）の記述が実態と一致するか確認
- [ ] root_squashとextensiveMountPointCheckの関係が正確に記述されているか確認
