---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：131-iSCSIボリューム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的な閾値**：コード上のタイムアウト値以外の要件は未確認
  2. **CSIマイグレーション対象外の記述**：明示的なドキュメントソースなし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/volume/iscsi/iscsi.go` - プラグイン本体・データ構造
- E-02: `pkg/volume/iscsi/iscsi_util.go` - ユーティリティ処理（AttachDisk/DetachDisk）
- E-03: `pkg/volume/iscsi/attacher.go` - Attacher/Detacher 実装
- E-04: `pkg/volume/iscsi/disk_manager.go` - diskManager インターフェース
- E-05: Kubernetes API 型定義 `k8s.io/api/core/v1.ISCSIVolumeSource`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プラグイン名は kubernetes.io/iscsi | E-01 (59行目) | ○ |
| C-02 | ReadWriteOnce, ReadOnlyMany をサポート | E-01 (97-102行目) | ○ |
| C-03 | マルチパスを最小2パスから有効とする | E-02 (46行目 minMultipathCount=2) | ○ |
| C-04 | 最大接続試行回数は5回 | E-02 (54行目 maxAttachAttempts=5) | ○ |
| C-05 | デバイス検出タイムアウトは30秒 | E-02 (61行目 deviceDiscoveryTimeout=30) | ○ |
| C-06 | マルチパスデバイスタイムアウトは10秒 | E-02 (58行目 multipathDeviceTimeout=10) | ○ |
| C-07 | ポートデフォルトは3260 | E-01 (472-477行目 portalMounter) | ○ |
| C-08 | CHAP認証をSecret経由で管理 | E-01 (617-652行目 createSecretMap) | ○ |
| C-09 | CHAP シークレットはログに出力しない | E-02 (99-100行目, 129-130行目) | ○ |
| C-10 | node.startup=manual に設定 | E-02 (372-377行目) | ○ |
| C-11 | node.session.scan=manual に設定 | E-02 (110-115行目) | ○ |
| C-12 | SELinux マウントコンテキストサポート | E-01 (280-290行目, 385-389行目) | ○ |
| C-13 | iscsi.json で設定を永続化 | E-02 (207-219行目 persistISCSIFile) | ○ |
| C-14 | UncertainProgressError で永続化失敗を通知 | E-02 (477-481行目) | ○ |
| C-15 | targetLocks で同一ターゲットを排他制御 | E-02 (316-317行目) | ○ |
| C-16 | isSessionBusy でセッション共有判定 | E-02 (907-923行目) | ○ |
| C-17 | FS/Blockデバイス両モードサポート | E-01 (56行目 BlockVolumePlugin) | ○ |
| C-18 | Attach() は no-op | E-03 (70-72行目) | ○ |
| C-19 | WaitForAttach で実質的な接続を実行 | E-03 (83-90行目) | ○ |
| C-20 | MountDevice で FormatAndMount 実行 | E-03 (106-141行目) | ○ |
| C-21 | exit code 15 をセッション既存として処理 | E-02 (64行目, 881行目) | ○ |
| C-22 | exit code 2, 21 をログアウト時に無視 | E-02 (67-69行目, 736行目, 744行目) | ○ |
| C-23 | SupportsMountOption が true | E-01 (89-91行目) | ○ |
| C-24 | CSI マイグレーション対象外 | **根拠なし** | △ |
| C-25 | パフォーマンス要件（ネットワーク遅延依存） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- CSI マイグレーション対象外の明示的なソース
  - 候補：Kubernetes公式ドキュメント / CSI Migration KEP / pkg/volume/csimigration
- パフォーマンス要件の正式定義
  - 候補：SLA文書 / パフォーマンステスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードに基づく技術的記述は高精度
- 1: 中リスク - CSIマイグレーション状況は変更される可能性がある
- 0: 低リスク - CHAP認証のセキュリティ記述はコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] iSCSI ターゲット情報のパラメータ一覧が実際の API 定義と一致するか
- [ ] iscsiadm コマンドのエラーコード処理が最新のopen-iscsiバージョンと整合するか
- [ ] マルチパス関連の定数値（minMultipathCount=2, maxAttachAttempts=5等）が正確か
- [ ] SELinux フィーチャーゲート名が現行バージョンと一致するか
