---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：132-FCボリューム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **FC ゾーニングに関する記述**：ストレージ側の管理であり、Kubernetes コードには直接的な根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/volume/fc/fc.go` - プラグイン本体
- E-02: `pkg/volume/fc/fc_util.go` - ユーティリティ処理
- E-03: Kubernetes API 型定義 `k8s.io/api/core/v1.FCVolumeSource`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プラグイン名は kubernetes.io/fc | E-01 (56行目) | ○ |
| C-02 | ReadWriteOnce, ReadOnlyMany サポート | E-01 (104-109行目) | ○ |
| C-03 | WWN+LUN と WWID の2方式をサポート | E-01 (510-524行目) | ○ |
| C-04 | by-path 検索の正規表現パターン | E-02 (65行目) | ○ |
| C-05 | by-id 検索は scsi- プレフィックス | E-02 (94行目) | ○ |
| C-06 | WWID 内の空白をアンダースコアに置換 | E-01 (519行目) | ○ |
| C-07 | 2フェーズ検索（再スキャン付き） | E-02 (214-238行目) | ○ |
| C-08 | マルチパスデバイス優先 | E-02 (244-248行目) | ○ |
| C-09 | SCSI バス再スキャンは "- - -" を書き込み | E-02 (134-143行目) | ○ |
| C-10 | デバイス削除は /sys/block/{dev}/device/delete | E-02 (127-131行目) | ○ |
| C-11 | blockdev --flushbufs でフラッシュ | E-02 (117行目) | ○ |
| C-12 | multipath -f でマルチパスデバイス削除 | E-02 (403行目) | ○ |
| C-13 | SELinux マウントコンテキストサポート | E-01 (284-294行目) | ○ |
| C-14 | ブロックボリュームモードサポート | E-01 (53行目) | ○ |
| C-15 | SupportsMountOption が true | E-01 (96-98行目) | ○ |
| C-16 | parsePDName で globalPDPath からデバイス情報復元 | E-02 (163-186行目) | ○ |
| C-17 | DetachBlockFCDisk で symlink 経由のデバイス解決 | E-02 (317-400行目) | ○ |
| C-18 | FC ゾーニングはストレージ側で管理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- FC ゾーニングに関する Kubernetes 側の明示的なドキュメント
  - 候補：Kubernetes公式ドキュメント / FC ストレージベンダーガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - デバイス検索ロジックはコードと一致
- 0: 低リスク - Detach 処理の順序は正確

## 6) レビュアーチェックリスト（最小）
- [ ] WWN+LUN と WWID の排他指定がバリデーションされているか
- [ ] by-path 正規表現がカーネルバージョンの違いに対応しているか
- [ ] マルチパスデバイスの検出が multipath-tools のバージョンに依存しないか
