---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：133-Localボリューム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Windows プラットフォーム動作差異**：コード上の条件分岐は確認済みだが、実際の動作検証は未実施

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/volume/local/local.go` - プラグイン全体の実装
- E-02: Kubernetes API 型定義 `k8s.io/api/core/v1.LocalVolumeSource`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プラグイン名は kubernetes.io/local-volume | E-01 (64行目) | ○ |
| C-02 | ReadWriteOnce のみサポート | E-01 (100-105行目) | ○ |
| C-03 | PVのみサポート（インラインボリューム不可） | E-01 (83-86行目) | ○ |
| C-04 | ディレクトリとブロックデバイスのみ | E-01 (284-292行目) | ○ |
| C-05 | デフォルト fsType は ext4 | E-01 (44行目) | ○ |
| C-06 | バインドマウントを使用 | E-01 (582行目) | ○ |
| C-07 | バックステップチェック実施 | E-01 (537-540行目) | ○ |
| C-08 | fsGroup 競合時に警告イベント発行 | E-01 (568行目) | ○ |
| C-09 | 初回マウント時のみ所有権変更 | E-01 (620-625行目) | ○ |
| C-10 | volumeLocks で排他制御 | E-01 (530-531行目) | ○ |
| C-11 | SELinux コンテキストマウント非サポート | E-01 (96-98行目) | ○ |
| C-12 | NodeExpandableVolumePlugin 実装 | E-01 (61行目) | ○ |
| C-13 | ブロックデバイスリサイズは GenericResizeFS | E-01 (413行目) | ○ |
| C-14 | ディレクトリリサイズは NO-OP | E-01 (421行目) | ○ |
| C-15 | UnmountDevice はブロックデバイスパスのみ対象 | E-01 (474-486行目) | ○ |
| C-16 | filterPodMounts で Pod ディレクトリのみフィルタ | E-01 (631-639行目) | ○ |
| C-17 | MountSensitiveWithoutSystemd でマウント | E-01 (590行目) | ○ |
| C-18 | ConstructVolumeSpec でブロックデバイスパス復元 | E-01 (196-242行目) | ○ |
| C-19 | ブロックボリュームモードサポート | E-01 (60行目) | ○ |
| C-20 | Windows 動作差異（MkdirAll スキップ） | E-01 (574-580行目) | △ |

## 4) 不足情報（Unknown / Missing）
- Windows プラットフォームでの実際の動作検証結果
  - 候補：E2Eテスト結果 / Windows ノードテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の記述は全てコードから確認済み
- 1: 中リスク - Windows 対応の記述はコード分岐のみ確認

## 6) レビュアーチェックリスト（最小）
- [ ] ノードアフィニティとの連携がドキュメントに反映されているか
- [ ] fsGroup 競合検出のロジックが正確か
- [ ] ブロックデバイスのリサイズ時の動作が期待通りか
