---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：139-Service管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **IP/ポート割り当てのロールバック詳細**：storage/alloc.go の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/registry/core/service/strategy.go` - Strategy 定義
- E-02: `pkg/registry/core/service/storage/storage.go` - Storage 実装
- E-03: Kubernetes API 型定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Namespace スコープ | E-01 (52-54行目) | ○ |
| C-02 | 作成時に Status クリア | E-01 (69-74行目) | ○ |
| C-03 | 更新時に Status 保持 | E-01 (77-84行目) | ○ |
| C-04 | dropTypeDependentFields の存在 | E-01 (240-317行目) | ○ |
| C-05 | ExternalName 以外は ClusterIP 必要 | E-01 (319-324行目) | ○ |
| C-06 | NodePort/LB で NodePort 必要 | E-01 (347-352行目) | ○ |
| C-07 | LB + Local で HCNodePort 必要 | E-01 (374-382行目) | ○ |
| C-08 | ClusterIP/ClusterIPs の自動クリア | E-01 (255-260行目) | ○ |
| C-09 | NodePort の自動クリア | E-01 (272-276行目) | ○ |
| C-10 | HealthCheckNodePort の自動クリア | E-01 (281-283行目) | ○ |
| C-11 | AllocateLoadBalancerNodePorts クリア | E-01 (287-293行目) | ○ |
| C-12 | LoadBalancerClass クリア | E-01 (297-299行目) | ○ |
| C-13 | ExternalTrafficPolicy クリア | E-01 (303-305行目) | ○ |
| C-14 | LB Status クリア | E-01 (314-316行目) | ○ |
| C-15 | AllowCreateOnUpdate は true | E-01 (102-104行目) | ○ |
| C-16 | SelectableFields: clusterIP, type | E-01 (198-205行目) | ○ |
| C-17 | GetWarningsForService | E-01 (94-96行目) | ○ |
| C-18 | StatusREST で IP 警告 | E-01 (163-177行目) | ○ |
| C-19 | REST 構造体に ipallocator/portallocator | E-02 (60-68行目) | ○ |
| C-20 | IP/ポート割り当てのロールバック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- IP/ポート割り当てのロールバック処理の詳細
  - 候補：`pkg/registry/core/service/storage/alloc.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Strategy のフィールドクリーンアップロジックは正確
- 1: 中リスク - 割り当てロールバックの詳細

## 6) レビュアーチェックリスト（最小）
- [ ] デュアルスタック対応の IPFamily/IPFamilyPolicy の挙動が正確か
- [ ] タイプ変更時の自動クリーンアップが全パターン網羅されているか
- [ ] IP/ポートアロケータのエラーハンドリングが適切か
