---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：150-SecurityContext管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **AppArmorプロファイル管理の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/securitycontext/accessors.go` -- Accessor/Mutatorインターフェースと実装
- E-02: `pkg/securitycontext/util.go` -- ユーティリティ関数
- E-03: `pkg/securitycontext/` -- ディレクトリ構成
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` -- 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PodSecurityContextAccessorインターフェースに12個のメソッドがある | E-01 (26-39行目) | ○ |
| C-02 | ContainerSecurityContextAccessorインターフェースに10個のメソッドがある | E-01 (253-265行目) | ○ |
| C-03 | podSecurityContextWrapperはnil安全である | E-01 (82-86行目, 88-93行目等) | ○ |
| C-04 | effectiveContainerSecurityContextWrapperがPod+コンテナを統合する | E-01 (451-454行目) | ○ |
| C-05 | SELinuxOptionsはコンテナ設定がPod設定をオーバーライドする | E-01 (479-483行目), E-02 (58-61行目) | ○ |
| C-06 | RunAsUserはコンテナ設定がPod設定をオーバーライドする | E-01 (490-495行目), E-02 (91-94行目) | ○ |
| C-07 | DetermineEffectiveSecurityContextがPod+コンテナ設定をマージする | E-02 (44-122行目) | ○ |
| C-08 | WindowsOptionsは部分オーバーライドが行われる | E-02 (63-79行目) | ○ |
| C-09 | AddNoNewPrivilegesはAllowPrivilegeEscalation=falseの場合trueを返す | E-02 (179-191行目) | ○ |
| C-10 | defaultMaskedPathsにsync.OnceValueが使用されている | E-02 (196行目) | ○ |
| C-11 | /proc/asound, /proc/kcore等がデフォルトマスクパスに含まれる | E-02 (197-211行目) | ○ |
| C-12 | CPUサーマルスロットルパスが動的に追加される | E-02 (212-217行目) | ○ |
| C-13 | UnmaskedProcMountの場合はマスクパス/読み取り専用パスが空 | E-02 (233-235行目, 245-248行目) | ○ |
| C-14 | DetermineEffectiveRunAsUserがPod→コンテナの優先順位で判定 | E-02 (127-141行目) | ○ |
| C-15 | 機能一覧でNo.150がSecurityContext管理として定義 | E-04 (151行目) | ○ |
| C-16 | AppArmorプロファイル管理がpkg/security/apparmor/に存在する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- AppArmorプロファイル管理の詳細は`pkg/security/apparmor/`ディレクトリの内容を確認する必要がある
  - 候補：`pkg/security/apparmor/validate.go` 等

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- Accessor/Mutatorインターフェースとユーティリティ関数はソースコードから直接確認済み
- 0: 低リスク -- DetermineEffectiveSecurityContextのマージロジックはソースコードから詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] DetermineEffectiveSecurityContextのマージ優先順位がコードと一致しているか
- [ ] defaultMaskedPathsのリストがコードと一致しているか
- [ ] AddNoNewPrivilegesの判定ロジックがコードと一致しているか
- [ ] WindowsOptionsの部分オーバーライドロジックがコードと一致しているか
