---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：158-リース管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **ハートビート間隔**：10秒間隔はKubelet設定のデフォルト値であり、本コードには含まれない

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/registry/coordination/lease/strategy.go` - Lease戦略
- E-02: `pkg/registry/coordination/rest/storage_coordination.go` - RESTストレージプロバイダー
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LeaseはNamespaceスコープ | E-01 (42-44行目: NamespaceScoped=true) | ○ |
| C-02 | AllowCreateOnUpdate=true | E-01 (84-86行目) | ○ |
| C-03 | AllowUnconditionalUpdate=false | E-01 (99-101行目) | ○ |
| C-04 | PrepareForCreateでフィーチャーゲートチェック | E-01 (47-54行目) | ○ |
| C-05 | PrepareForUpdateでフィールド保持ロジック | E-01 (57-68行目) | ○ |
| C-06 | CoordinatedLeaderElectionフィーチャーゲート使用 | E-01 (49行目) | ○ |
| C-07 | v1/v1beta1/v1alpha2の3バージョン | E-02 (40-56行目) | ○ |
| C-08 | v1でleasesを登録 | E-02 (61-73行目) | ○ |
| C-09 | v1beta1でleasecandidatesを登録 | E-02 (75-87行目) | ○ |
| C-10 | v1alpha2でleasecandidatesを登録 | E-02 (89-101行目) | ○ |
| C-11 | coordination.GroupNameを返す | E-02 (103-105行目) | ○ |
| C-12 | ValidateLeaseでバリデーション | E-01 (71-74行目) | ○ |
| C-13 | ValidateLeaseUpdateで更新バリデーション | E-01 (89-91行目) | ○ |
| C-14 | ハートビートは10秒間隔 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ハートビート間隔はKubeletの設定（--node-status-update-frequency）で決まり、このレジストリコードには含まれない
  - 候補：`pkg/kubelet/kubelet.go` / Kubelet設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: Lease戦略の全メソッドは正確に記述されている
- 0: 3バージョンのストレージ構造は正確
- 1: ハートビート間隔はKubelet側の設定に依存

## 6) レビュアーチェックリスト（最小）
- [ ] Lease戦略のフィーチャーゲート制御が正確か
- [ ] 3バージョンのストレージ登録が正確か
- [ ] LeaseCandidate戦略の記述が正確か
