---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：159-外部JWT署名

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Sign RPCのレイテンシ要件**：ミリ秒オーダーの記述はコード上の根拠なし

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/externaljwt/apis/v1alpha1/api.proto` - v1alpha1プロトコル定義
- E-02: `staging/src/k8s.io/externaljwt/apis/v1/` - v1 API
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Sign RPCが定義されている | E-01 (34行目) | ○ |
| C-02 | FetchKeys RPCが定義されている | E-01 (43行目) | ○ |
| C-03 | Metadata RPCが定義されている | E-01 (47行目) | ○ |
| C-04 | SignJWTRequestにclaimsフィールド | E-01 (50-54行目) | ○ |
| C-05 | SignJWTResponseにheaderとsignature | E-01 (56-68行目) | ○ |
| C-06 | JWTヘッダー制約（alg, kid, typ） | E-01 (57-61行目コメント) | ○ |
| C-07 | FetchKeysResponseにkeys, data_timestamp, refresh_hint | E-01 (72-83行目) | ○ |
| C-08 | Key構造体にkey_id, key, exclude_from_oidc_discovery | E-01 (85-99行目) | ○ |
| C-09 | max_token_expiration_secondsが600秒以上 | E-01 (112-113行目コメント) | ○ |
| C-10 | max-token-expiration超過時にエラー | E-01 (108行目コメント) | ○ |
| C-11 | extend-token-expiration時の計算式 | E-01 (110行目コメント) | ○ |
| C-12 | 署名アルゴリズムはRS256/ES256/ES384/ES512 | E-01 (60行目コメント) | ○ |
| C-13 | v1alpha1とv1の2バージョン | E-01, E-02 | ○ |
| C-14 | Sign RPCはミリ秒オーダーのレイテンシ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Sign RPCのレイテンシ要件はパフォーマンス設計に基づくが、protoファイルやコード上の根拠がない
  - 候補：KEP / SIG-Auth設計文書

## 5) リスクフラグ（レビュー観点）
- 0: gRPCプロトコル定義は正確
- 0: ビジネスルール（ヘッダー制約、有効期限等）はprotoコメントから正確に抽出
- 1: パフォーマンス要件は外部ドキュメント依存

## 6) レビュアーチェックリスト（最小）
- [ ] gRPCサービス定義（3 RPC）が正確か
- [ ] メッセージ型のフィールドが正確か
- [ ] ビジネスルール（ヘッダー制約、有効期限計算）が正確か
- [ ] v1alpha1とv1の差異が正確に記述されているか
