---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：18-Node Lifecycleコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **monitorNodeHealthの完全なフロー**：コードが大きいため一部のみ読み込み

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/controller/nodelifecycle/node_lifecycle_controller.go` - メインコントローラーコード（450行まで読み込み）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ノードヘルスモニタリングとTaint管理 | E-01, E-02 | ○ |
| C-02 | UnreachableTaintTemplate/NotReadyTaintTemplate定義（71-81行目） | E-01 | ○ |
| C-03 | nodeConditionToTaintKeyStatusMap（87-104行目） | E-01 | ○ |
| C-04 | ZoneState: Initial/Normal/PartialDisruption/FullDisruption（120-124行目） | E-01 | ○ |
| C-05 | Controller構造体（218-303行目） | E-01 | ○ |
| C-06 | nodeHealthData/nodeHealthMap（168-210行目） | E-01 | ○ |
| C-07 | NewNodeLifecycleController（306-444行目） | E-01 | ○ |
| C-08 | SeparateTaintEvictionControllerフィーチャーゲート | E-01 | ○ |
| C-09 | retrySleepTime = 20ms | E-01 | ○ |
| C-10 | podUpdateWorkerSize = 4 | E-01 | ○ |
| C-11 | nodeUpdateWorkerSize = 8 | E-01 | ○ |
| C-12 | labelReconcileInfo（beta/stableラベル調整） | E-01 | ○ |
| C-13 | Pod/Node/Lease/DaemonSet Informer登録 | E-01 | ○ |
| C-14 | nodesToRetryによるリトライ管理 | E-01 | ○ |
| C-15 | enterPartialDisruptionFunc/enterFullDisruptionFunc | E-01 | ○ |
| C-16 | nodeUpdateQueue/podUpdateQueue | E-01 | ○ |
| C-17 | taintEvictionControllerのインライン初期化 | E-01 | ○ |
| C-18 | monitorNodeHealthの完全なフロー（tryUpdateNodeHealth/computeZoneState/handleDisruption） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: monitorNodeHealthのRun関数以降のコードは一部のみ読み込み。tryUpdateNodeHealth、computeZoneState、handleDisruptionの詳細は未検証。
  - 候補：`pkg/controller/nodelifecycle/node_lifecycle_controller.go`（450行目以降）

## 5) リスクフラグ（レビュー観点）
- 1: monitorNodeHealthの詳細フロー（特にゾーン状態遷移ロジック）の記述が不十分な可能性
- 0: TaintEvictionControllerの連携部分の記述は簡略化されている

## 6) レビュアーチェックリスト（最小）
- [ ] monitorNodeHealthの完全なフローが必要な場合は追加調査
- [ ] ゾーン状態遷移の閾値設定の説明が十分か
- [ ] SeparateTaintEvictionControllerの分離に関する説明が十分か
