---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-TTLコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。全項目にコードレベルの根拠あり。

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/controller/ttl/ttl_controller.go` - メインコントローラーコード（全312行を読み込み済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | クラスタサイズに基づきTTLアノテーションを設定 | E-01 | ○ |
| C-02 | Controller構造体（56-78行目） | E-01 | ○ |
| C-03 | ttlBoundary/ttlBoundaries（106-120行目） | E-01 | ○ |
| C-04 | NewTTLController（81-104行目） | E-01 | ○ |
| C-05 | Run（123-146行目） | E-01 | ○ |
| C-06 | addNode（148-165行目）: nodeCount++, boundaryStep調整 | E-01 | ○ |
| C-07 | updateNode（167-178行目） | E-01 | ○ |
| C-08 | deleteNode（181-206行目）: nodeCount--, boundaryStep調整 | E-01 | ○ |
| C-09 | updateNodeIfNeeded（295-311行目）: TTL比較とPatch | E-01 | ○ |
| C-10 | patchNodeWithAnnotation（271-293行目）: Strategic Merge Patch | E-01 | ○ |
| C-11 | TTL境界値: 0/15/30/60/300秒 | E-01 | ○ |
| C-12 | sizeMin/sizeMaxのオーバーラップ（ヒステリシス） | E-01 | ○ |
| C-13 | getIntFromAnnotation（246-262行目） | E-01 | ○ |
| C-14 | RWMutexによるnodeCount/desiredTTL保護 | E-01 | ○ |
| C-15 | TTL値が同じ場合はPatchしない | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全項目にコードレベルの根拠あり。コンパクトなコントローラーのため網羅的に検証済み。

## 6) レビュアーチェックリスト（最小）
- [ ] TTL境界値テーブルの値が正確か（コードの定数値と一致）
- [ ] alpha機能である旨の注意書きが十分か
