---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-TTL After Finishedコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。全項目にコードレベルの根拠あり。

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/controller/ttlafterfinished/ttlafterfinished_controller.go` - メインコントローラーコード（全334行を読み込み済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 完了JobのTTL期限切れで自動削除 | E-01 | ○ |
| C-02 | Controller構造体（54-70行目） | E-01 | ○ |
| C-03 | New（73-105行目）: Informerハンドラ登録 | E-01 | ○ |
| C-04 | Run（108-131行目）: ワーカー起動 | E-01 | ○ |
| C-05 | addJob/updateJob: needsCleanupチェック（133-150行目） | E-01 | ○ |
| C-06 | processJob（206-261行目）: 二重チェックとForeground削除 | E-01 | ○ |
| C-07 | processTTL（265-285行目）: TTL期限判定 | E-01 | ○ |
| C-08 | needsCleanup（288-290行目）: TTL設定+完了チェック | E-01 | ○ |
| C-09 | timeLeft（305-317行目）: 残り時間計算 | E-01 | ○ |
| C-10 | jobFinishTime（320-333行目）: Complete/Failedから完了時刻取得 | E-01 | ○ |
| C-11 | Foreground伝播ポリシーでの削除 | E-01 | ○ |
| C-12 | Preconditions（UID一致）での誤削除防止 | E-01 | ○ |
| C-13 | enqueueAfter: TTL未到来時の遅延再キュー | E-01 | ○ |
| C-14 | DeletionTimestampチェック | E-01 | ○ |
| C-15 | 時刻スキュー検出と警告ログ | E-01 | ○ |
| C-16 | JobDeletionDurationSecondsメトリクス | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全項目にコードレベルの根拠あり。コンパクトなコントローラーのため網羅的に検証済み。

## 6) レビュアーチェックリスト（最小）
- [ ] Foreground削除によるカスケード削除の説明が十分か
- [ ] 二重チェック（キャッシュ → 最新データ）の理由説明が明確か
