---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-ResourceQuotaコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張が根拠付きのため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/resourcequota/resource_quota_controller.go` 56-77行目（ControllerOptions構造体）
- E-02: `pkg/controller/resourcequota/resource_quota_controller.go` 80-103行目（Controller構造体）
- E-03: `pkg/controller/resourcequota/resource_quota_controller.go` 106-191行目（NewController）
- E-04: `pkg/controller/resourcequota/resource_quota_controller.go` 222-252行目（addQuota）
- E-05: `pkg/controller/resourcequota/resource_quota_controller.go` 254-290行目（worker）
- E-06: `pkg/controller/resourcequota/resource_quota_controller.go` 293-337行目（Run）
- E-07: `pkg/controller/resourcequota/resource_quota_controller.go` 367-415行目（syncResourceQuota）
- E-08: `pkg/controller/resourcequota/resource_quota_controller.go` 418-450行目（replenishQuota）
- E-09: `pkg/controller/resourcequota/resource_quota_controller.go` 453-521行目（Sync）
- E-10: `pkg/controller/resourcequota/resource_quota_controller.go` 558-570行目（GetQuotableResources）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` 23行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Controller構造体はqueue/missingUsageQueueの2キューを持つ | E-02 (88-90行目) | ○ |
| C-02 | queueはresourcequota_primary、missingUsageQueueはresourcequota_priority | E-03 (114, 118行目) | ○ |
| C-03 | addQuotaでSpec.Hard != Status.HardならmissingUsageQueueに投入 | E-04 (232-234行目) | ○ |
| C-04 | addQuotaで未計上制約があればmissingUsageQueueに投入 | E-04 (238-247行目) | ○ |
| C-05 | Update時はSpec.Hardの変更のみ検出 | E-03 (144-146行目) | ○ |
| C-06 | syncResourceQuotaでquota.CalculateUsageを呼び出す | E-07 (384行目) | ○ |
| C-07 | dirtyの場合のみUpdateStatusを呼び出す | E-07 (408-413行目) | ○ |
| C-08 | 使用量をhardResourcesでマスクする | E-07 (394-395行目) | ○ |
| C-09 | replenishQuotaで変更リソースに関連するQuotaをエンキュー | E-08 (442-448行目) | ○ |
| C-10 | Runでworkers個のワーカーをqueue/missingUsageQueue両方に起動 | E-06 (318-325行目) | ○ |
| C-11 | resyncPeriod > 0ならenqueueAllで定期再同期 | E-06 (328-334行目) | ○ |
| C-12 | Syncでworkerlock.Lock()による排他制御 | E-09 (485-486行目) | ○ |
| C-13 | workerがworkerLock.RLock()を取得して処理 | E-05 (263-264行目) | ○ |
| C-14 | GetQuotableResourcesはcreate/list/watch/deleteサポートリソースを抽出 | E-10 (563行目) | ○ |
| C-15 | QuotaMonitor初期化とSyncMonitors | E-03 (160-188行目) | ○ |
| C-16 | CalculateUsage失敗時も取得済み使用量で更新試行 | E-07 (385-388行目) | ○ |
| C-17 | NotFound時はログ出力し正常終了 | E-07 via syncResourceQuotaFromKey (355-357行目) | ○ |
| C-18 | RateLimitingキューでリトライ | E-05 (277行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠があるため、不足情報はない

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] Controller構造体の2キュー構成がコードと一致しているか確認
- [ ] addQuotaの優先キュー振り分けロジックがコードと一致しているか確認
- [ ] syncResourceQuotaのdirty判定ロジックがコードと一致しているか確認
