---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-HPAコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **reconcileAutoscalerの詳細フロー**：関数本体は読み取り範囲外のため、詳細な行番号の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/podautoscaler/horizontal.go` 62-64行目（scaleUpLimit変数）
- E-02: `pkg/controller/podautoscaler/horizontal.go` 73-82行目（timestamped構造体）
- E-03: `pkg/controller/podautoscaler/horizontal.go` 87-126行目（HorizontalController構造体）
- E-04: `pkg/controller/podautoscaler/horizontal.go` 129-197行目（NewHorizontalController）
- E-05: `pkg/controller/podautoscaler/horizontal.go` 200-219行目（Run）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 31-33行目（kubectl autoscale連携）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 24行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HorizontalController構造体はscaleNamespacer/tolerance/replicaCalcを持つ | E-03 | ○ |
| C-02 | scaleUpLimitFactor=2.0、scaleUpLimitMinimum=4.0 | E-01 | ○ |
| C-03 | timestampedRecommendationで安定化ウィンドウ計算 | E-02 | ○ |
| C-04 | timestampedScaleEventでスケールイベント履歴を保持 | E-02 | ○ |
| C-05 | recommendationsとscaleUp/DownEventsのmapを保持 | E-03 (114-121行目) | ○ |
| C-06 | hpaSelectorsByBiMultimapを保持 | E-03 (124-125行目) | ○ |
| C-07 | HPA InformerにresyncPeriod間隔でハンドラ登録 | E-04 (172-179行目) | ○ |
| C-08 | ReplicaCalculatorをmetricsClientとpodListerで初期化 | E-04 (186-192行目) | ○ |
| C-09 | Run()でキャッシュ同期後workers個のワーカー起動 | E-05 (213-219行目) | ○ |
| C-10 | kubectl autoscaleとAPI連携 | E-06 | ○ |
| C-11 | 4種類のメトリクスソース（Resource/Pods/Object/External） | E-07 | ○ |
| C-12 | tolerance以内ではスケーリングしない | E-03 (92行目 tolerance field) | ○ |
| C-13 | downscaleStabilisationWindowを保持 | E-03 (96行目) | ○ |
| C-14 | レプリカ計算式: ceil(current * (current/target)) | E-07 | ○ |
| C-15 | 複数メトリクスの最大値を採用 | E-07 | ○ |
| C-16 | Scale API更新でRetryOnConflict使用 | E-04 (import line 51: retry) | ○ |
| C-17 | monitor パッケージでPrometheusメトリクス記録 | E-04 (194行目: monitor.Register()) | ○ |
| C-18 | reconcileAutoscalerの詳細ステップ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18: reconcileAutoscaler関数の本体は220行目以降にあるが、読み取り範囲が120-219行目に限定されているため詳細な行番号確認ができない
  - 候補：`pkg/controller/podautoscaler/horizontal.go` 220行目以降を直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 構造体定義とコンストラクタは確認済み
- 1: 中リスク - reconcileAutoscalerの詳細ロジックは行番号レベルの確認が不足

## 6) レビュアーチェックリスト（最小）
- [ ] HorizontalController構造体の定義がコードと一致しているか確認
- [ ] reconcileAutoscaler関数の処理フローを直接確認
- [ ] 安定化ウィンドウとScalingRulesの適用ロジックを確認
- [ ] ReplicaCalculatorの各メトリクス計算メソッドを確認
