---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-PodGCコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張が根拠付きのため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/podgc/gc_controller.go` 48行目（gcCheckPeriod定数）
- E-02: `pkg/controller/podgc/gc_controller.go` 51行目（quarantineTime定数）
- E-03: `pkg/controller/podgc/gc_controller.go` 54-67行目（PodGCController構造体）
- E-04: `pkg/controller/podgc/gc_controller.go` 75-92行目（NewPodGCInternal）
- E-05: `pkg/controller/podgc/gc_controller.go` 94-115行目（Run）
- E-06: `pkg/controller/podgc/gc_controller.go` 117-134行目（gc）
- E-07: `pkg/controller/podgc/gc_controller.go` 136-141行目（isPodTerminated）
- E-08: `pkg/controller/podgc/gc_controller.go` 144-146行目（isPodTerminating）
- E-09: `pkg/controller/podgc/gc_controller.go` 148-191行目（gcTerminating）
- E-10: `pkg/controller/podgc/gc_controller.go` 193-226行目（gcTerminated）
- E-11: `pkg/controller/podgc/gc_controller.go` 229-268行目（gcOrphaned）
- E-12: `pkg/controller/podgc/gc_controller.go` 270-291行目（discoverDeletedNodes）
- E-13: `pkg/controller/podgc/gc_controller.go` 302-320行目（gcUnscheduledTerminating）
- E-14: `pkg/controller/podgc/gc_controller.go` 325-340行目（byEvictionAndCreationTimestamp）
- E-15: `pkg/controller/podgc/gc_controller.go` 346-366行目（markFailedAndDeletePodWithCondition）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | gcCheckPeriod=20秒 | E-01 | ○ |
| C-02 | quarantineTime=40秒 | E-02 | ○ |
| C-03 | PodGCControllerはnodeQueue(DelayingQueue)を持つ | E-03 (62行目) | ○ |
| C-04 | Run()で単一ワーカーをgcCheckPeriod間隔で起動 | E-05 (111-113行目) | ○ |
| C-05 | gc()は4つのサブ関数を順次呼び出す | E-06 (128-133行目) | ○ |
| C-06 | gcTerminatedはthreshold超過分を削除 | E-10 (201-202行目) | ○ |
| C-07 | gcTerminatedはEviction優先+CreationTimestamp順にソート | E-14 | ○ |
| C-08 | gcTerminatingはNotReadyかつout-of-service Taintを条件 | E-09 (162行目) | ○ |
| C-09 | gcOrphanedはquarantine後にAPI Server確認 | E-11 (239, 243行目) | ○ |
| C-10 | gcOrphanedはDisruptionTarget条件を付与 | E-11 (253-259行目) | ○ |
| C-11 | gcUnscheduledTerminatingはDeletionTimestamp!=nil && NodeName=="" | E-13 (307行目) | ○ |
| C-12 | markFailedAndDeletePodWithConditionでPhase=Failed パッチ | E-15 (354-363行目) | ○ |
| C-13 | GracePeriodSeconds=0で強制削除 | E-15 (365行目) | ○ |
| C-14 | 並行goroutineでPod削除 | E-10 (213-225行目) | ○ |
| C-15 | discoverDeletedNodesでnodeQueueからアイテム取得 | E-12 | ○ |
| C-16 | checkIfNodeExistsでAPI Server GET | E-15 via E-12 (279行目) | ○ |
| C-17 | terminatedPodThreshold=0でgcTerminated無効 | E-06 (128行目) | ○ |
| C-18 | metrics.RegisterMetrics()でメトリクス登録 | E-04 (90行目) | ○ |
| C-19 | Succeeded/Failed以外の場合のみパッチ | E-15 (354行目) | ○ |
| C-20 | sync.WaitGroupで並行削除の完了待機 | E-10 (212, 225行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠があるため、不足情報はない

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ソースコードが完全に読み取り済みで全主張が検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] 4つのGCサブ関数の呼び出し順序がコードと一致しているか確認
- [ ] quarantineメカニズムの動作がコードと一致しているか確認
- [ ] markFailedAndDeletePodWithConditionの2段階処理がコードと一致しているか確認
