---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-Certificate署名コントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張が根拠付きのため、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/certificates/certificate_controller.go` 42-54行目（構造体）
- E-02: `pkg/controller/certificates/certificate_controller.go` 56-113行目（コンストラクタ）
- E-03: `pkg/controller/certificates/certificate_controller.go` 67-76行目（レートリミッター）
- E-04: `pkg/controller/certificates/certificate_controller.go` 116-139行目（Run）
- E-05: `pkg/controller/certificates/certificate_controller.go` 148-168行目（processNextWorkItem）
- E-06: `pkg/controller/certificates/certificate_controller.go` 179-202行目（syncFunc）
- E-07: `pkg/controller/certificates/certificate_controller.go` 212-216行目（ignorableError）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 34-35行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CertificateController構造体はname/handler/queueを持つ | E-01 | ○ |
| C-02 | handlerはfunc(context.Context, *CSR) error型 | E-01 (51行目) | ○ |
| C-03 | エクスポネンシャルバックオフ200ms-1000s | E-03 (69行目) | ○ |
| C-04 | バケットリミッター10qps/100バースト | E-03 (71行目) | ○ |
| C-05 | Add/Update/DeleteでCSRをenqueue | E-02 (81-109行目) | ○ |
| C-06 | Delete時にTombstone対応あり | E-02 (94-105行目) | ○ |
| C-07 | Run()でworkers個のワーカー起動 | E-04 (133-137行目) | ○ |
| C-08 | Certificate発行済みならスキップ | E-06 (194-197行目) | ○ |
| C-09 | DeepCopy()で共有キャッシュ変更防止 | E-06 (200行目) | ○ |
| C-10 | handler()呼び出しで署名処理 | E-06 (201行目) | ○ |
| C-11 | ignorableErrorは高レベルログ出力 | E-05 (157-161行目) | ○ |
| C-12 | ignorableError型はstring型ベース | E-07 | ○ |
| C-13 | 成功時はqueue.Forget() | E-05 (165行目) | ○ |
| C-14 | 失敗時はqueue.AddRateLimited() | E-05 (156行目) | ○ |
| C-15 | kubectl certificate連携 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠があるため、不足情報はない

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ソースコードが完全に読み取り済みで全主張が検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] handler関数のシグネチャとプラグイン可能性がコードと一致しているか確認
- [ ] レートリミッター設定値がコードと一致しているか確認
- [ ] ignorableError処理がコードと一致しているか確認
