---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：3-認可（Authorization）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **system:mastersグループの特権動作**：RBAC実装詳細の確認が必要
  2. **ABACの非推奨ステータス**：公式ドキュメントとの照合が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/auth/authorizer/abac/abac.go` - ABACポリシー読み込みと認可判定
- E-02: `staging/src/k8s.io/apiserver/pkg/authentication/authenticatorfactory/delegating.go` - 認可チェーン構築の参考
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.3の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.3に関連する画面
- E-05: `pkg/auth/authorizer/abac/abac.go` 54-59行目 - PolicyList型とNewFromFile関数
- E-06: `pkg/registry/rbac/` ディレクトリ構造 - RBACレジストリの存在確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RBAC、ABAC、Webhook等のモードによる認可判定 | E-03 | ○ |
| C-02 | 複数の認可モードをチェーンとして構成 | E-03 | ○ |
| C-03 | ABACはポリシーファイルから読み込み | E-01, E-05 | ○ |
| C-04 | PolicyListがABACの認可判定を担当 | E-05 | ○ |
| C-05 | ポリシーファイルは1行1ポリシーのJSON形式 | E-01 | ○ |
| C-06 | RBAC定義はetcdに永続化 | E-06 | ○ |
| C-07 | RBACリソース（Role, ClusterRole等）のレジストリが存在 | E-06 | ○ |
| C-08 | kubectl authが認可確認に関連 | E-04 | ○ |
| C-09 | Decision は Allow, Deny, NoOpinion の3値 | E-03 | ○ |
| C-10 | Allow優先でチェーンが動作 | E-03 | ○ |
| C-11 | RBACはデフォルトで全て拒否 | E-03 | ○ |
| C-12 | ClusterRoleのaggregationRuleによる自動集約 | E-06 | ○ |
| C-13 | Node認可がKubeletリクエスト用に特化 | E-03 | ○ |
| C-14 | SubjectAccessReview APIが存在 | E-04 | ○ |
| C-15 | RBAC認可はInformerキャッシュから読み取り | E-06 | ○ |
| C-16 | Webhook認可サービスとの通信はTLS暗号化すべき | E-03 | ○ |
| C-17 | system:mastersグループの全リソースアクセス許可 | **根拠なし** | △ |
| C-18 | ABACは非推奨に向かっている | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- system:mastersグループの特権動作はRBAC初期設定のClusterRoleBindingから確認すべき
  - 候補：`plugin/pkg/auth/authorizer/rbac/bootstrappolicy/` / kube-apiserver初期化コード
- ABACの非推奨ステータスは公式ドキュメントのDeprecation Policyを参照すべき
  - 候補：Kubernetes公式ドキュメント / KEP

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ABACの実装はソースコードと一致
- 1: 中リスク - system:mastersの特権動作の詳細確認が必要
- 0: 低リスク - 画面マッピングはCSVデータと一致

## 6) レビュアーチェックリスト（最小）
- [ ] RBAC認可チェーンの実行順序が最新の実装と一致しているか確認
- [ ] system:mastersグループの特権がbootstrappolicyで定義されているか確認
- [ ] ABACの非推奨ステータスがKubernetes公式ドキュメントと一致しているか確認
