---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-Bootstrapコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/bootstrap/bootstrapsigner.go` - Bootstrap Signer
- E-02: `pkg/controller/bootstrap/tokencleaner.go` - Token Cleaner
- E-03: `pkg/controller/bootstrap/util.go` - ユーティリティ関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトConfigMapNamespaceはkube-public | E-01 (68行目, api.NamespacePublic) | ○ |
| C-02 | デフォルトConfigMapNameはcluster-info | E-01 (69行目, bootstrapapi.ConfigMapClusterInfo) | ○ |
| C-03 | デフォルトTokenSecretNamespaceはkube-system | E-01 (70行目, api.NamespaceSystem) | ○ |
| C-04 | キュー名はbootstrap_signer_queue | E-01 (111行目) | ○ |
| C-05 | ConfigMap FilterでName+Namespaceを一致確認 | E-01 (120行目) | ○ |
| C-06 | Secret FilterでType=BootstrapToken確認 | E-01 (139行目) | ○ |
| C-07 | signConfigMapでkubeconfigキーを取得 | E-01 (211行目, bootstrapapi.KubeConfigKey) | ○ |
| C-08 | JWSSignatureKeyPrefixで署名キーを識別 | E-01 (220行目) | ○ |
| C-09 | jws.ComputeDetachedSignatureで署名計算 | E-01 (230行目) | ○ |
| C-10 | 差分がある場合のみupdateConfigMap | E-01 (251-253行目) | ○ |
| C-11 | Token Cleanerキュー名はtoken_cleaner | E-02 (85行目) | ○ |
| C-12 | 10秒間隔でワーカー実行 | E-02 (131行目) | ○ |
| C-13 | GetExpirationでTTLと期限切れ取得 | E-02 (200行目) | ○ |
| C-14 | UIDプレコンディション付きで削除 | E-02 (204-206行目) | ○ |
| C-15 | TTL > 0の場合AddAfterでrequeue | E-02 (219行目) | ○ |
| C-16 | validateSecretForSigningでトークンID一致確認 | E-03 (44行目) | ○ |
| C-17 | usage-bootstrap-signingがtrueかチェック | E-03 (63-64行目) | ○ |
| C-18 | 期限切れトークンは署名対象から除外 | E-03 (58行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] JWS署名計算ロジックの正確性
- [ ] Token Cleanerの期限評価ロジックの正確性
- [ ] Secretフィルタリング条件の網羅性
