---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-Podスケジューリング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/scheduler/scheduler.go` - スケジューラー本体
- E-02: `pkg/scheduler/schedule_one.go` - ScheduleOne処理
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Scheduler構造体にCache, Extenders, NextPod等のフィールド | E-01 (68-124行目) | ○ |
| C-02 | ScheduleResult構造体にSuggestedHost, EvaluatedNodes, FeasibleNodes | E-01 (153-163行目) | ○ |
| C-03 | デフォルトparallelism = 16 | E-01 (267行目) | ○ |
| C-04 | podInitialBackoff = 1秒 | E-01 (264行目) | ○ |
| C-05 | podMaxBackoff = 10秒 | E-01 (265行目) | ○ |
| C-06 | New関数でプロファイル作成とキュー初期化 | E-01 (276-454行目) | ○ |
| C-07 | Run関数でScheduleOneを0間隔ループ実行 | E-01 (546行目) | ○ |
| C-08 | applyDefaultHandlersでSchedulePodとFailureHandler設定 | E-01 (126-129行目) | ○ |
| C-09 | pluginMetricsSamplePercent = 10 | E-02 (51行目) | ○ |
| C-10 | minFeasibleNodesToFind = 100 | E-02 (55行目) | ○ |
| C-11 | minFeasibleNodesPercentageToFind = 5 | E-02 (61行目) | ○ |
| C-12 | ScheduleOneでNextPod → frameworkForPod → schedulingCycle | E-02 (65-136行目) | ○ |
| C-13 | bindingCycleはgoroutineで非同期実行 | E-02 (123行目) | ○ |
| C-14 | PodInformerは非終了Podのみ取得 | E-01 (646行目) | ○ |
| C-15 | managedFieldsを削除してメモリ最適化 | E-01 (654-661行目) | ○ |
| C-16 | QueueingHintsによるイベントベース再キューイング | E-01 (462-529行目) | ○ |
| C-17 | ErrNoNodesAvailable定義 | E-01 (64行目) | ○ |
| C-18 | percentageOfNodesToScore adaptive式 | E-01 (199行目コメント) | ○ |
| C-19 | DynamicResourceAllocation Feature Gate対応 | E-01 (324-344行目) | ○ |
| C-20 | SchedulerAsyncAPICalls Feature Gate対応 | E-01 (348-350行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] schedulingCycleの各フェーズの順序が正確か
- [ ] bindingCycleの処理フローが正確か
- [ ] Preemptionフローの記述が十分か
