---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-NodeAffinityプラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/scheduler/framework/plugins/nodeaffinity/node_affinity.go` - NodeAffinityプラグイン本体

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NodeAffinity構造体に4フィールド | E-01 (39-44行目) | ○ |
| C-02 | 6インターフェースを実装（var _ assertions） | E-01 (46-51行目) | ○ |
| C-03 | プラグイン名はnames.NodeAffinity | E-01 (55行目) | ○ |
| C-04 | ErrReasonPodのメッセージ | E-01 (64行目) | ○ |
| C-05 | errReasonEnforcedのメッセージ | E-01 (67行目) | ○ |
| C-06 | errReasonConflictのメッセージ | E-01 (70行目) | ○ |
| C-07 | SignPodでNodeAffinitySignerとNodeSelectorSignerを返す | E-01 (79-88行目) | ○ |
| C-08 | EventsToRegisterでQH有効時はAdd|UpdateNodeLabel | E-01 (106-110行目) | ○ |
| C-09 | EventsToRegisterでQH無効時はAdd|UpdateNodeLabel|UpdateNodeTaint | E-01 (106行目) | ○ |
| C-10 | isSchedulableAfterNodeChangeでaddedNodeSelector事前チェック | E-01 (125-128行目) | ○ |
| C-11 | PreFilterでNodeAffinity/NodeSelector/Addedがすべてない場合Skip | E-01 (161-167行目) | ○ |
| C-12 | PreFilterでMatchFieldsからnode.Name候補抽出 | E-01 (177-206行目) | ○ |
| C-13 | 矛盾検出（nodeNames空）でUnschedulableAndUnresolvable | E-01 (202-203行目) | ○ |
| C-14 | PreFilterExtensionsはnil返却 | E-01 (212-214行目) | ○ |
| C-15 | FilterでaddedNodeSelector.Matchチェック | E-01 (221-223行目) | ○ |
| C-16 | Filterでフォールバック計算 | E-01 (226-229行目) | ○ |
| C-17 | PreScoreでpreferred条件なしの場合Skip | E-01 (258-261行目) | ○ |
| C-18 | ScoreでaddedPrefSchedTerms.Scoreを加算 | E-01 (276-278行目) | ○ |
| C-19 | NormalizeScoreでhelper.DefaultNormalizeScore使用 | E-01 (300-302行目) | ○ |
| C-20 | New関数でAddedAffinityのRequired/Preferredを解析 | E-01 (310-335行目) | ○ |
| C-21 | getArgsでNodeAffinityArgs取得とバリデーション | E-01 (337-343行目) | ○ |
| C-22 | isSchedulableAfterNodeChangeでunmatch→match検出 | E-01 (146-155行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードの具体的な行番号で裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] PreFilterのnode.Name候補抽出ロジック（OR/AND関係）の正確性
- [ ] QueueingHintのunmatch→match判定ロジックの正確性
- [ ] AddedAffinityの適用順序がFilter/Scoreで正しいか
