---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：41-NodeResourcesプラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の並列実行記述**：フレームワーク側の並列化実装の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `pkg/scheduler/framework/plugins/noderesources/fit.go`
- E-02: `pkg/scheduler/framework/plugins/noderesources/resource_allocation.go`
- E-03: `pkg/scheduler/framework/plugins/noderesources/balanced_allocation.go`
- E-04: `pkg/scheduler/framework/plugins/noderesources/least_allocated.go`
- E-05: `pkg/scheduler/framework/plugins/noderesources/most_allocated.go`
- E-06: `pkg/scheduler/framework/plugins/noderesources/requested_to_capacity_ratio.go`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Fitプラグインはフィルタリングとスコアリングの両方を実装 | E-01 (44-49行目: interface実装) | ○ |
| C-02 | PreFilterでPodリソース要求を事前計算 | E-01 (298-311行目) | ○ |
| C-03 | computePodResourceRequestがInitContainersとContainersを考慮 | E-01 (259-295行目) | ○ |
| C-04 | FilterでCPU/メモリ/EphemeralStorage/ScalarResourcesをチェック | E-01 (642-729行目) | ○ |
| C-05 | Pod数上限チェックを実施 | E-01 (645-654行目) | ○ |
| C-06 | 要求がAllocatableを超える場合はUnschedulableAndUnresolvable | E-01 (670-671行目) | ○ |
| C-07 | 3つのスコアリング戦略（LeastAllocated/MostAllocated/RequestedToCapacityRatio） | E-01 (64-89行目) | ○ |
| C-08 | LeastAllocatedの計算式 | E-04 (52-61行目) | ○ |
| C-09 | MostAllocatedの計算式 | E-05 (54-65行目) | ○ |
| C-10 | BalancedAllocationは標準偏差を使用 | E-03 (210-244行目) | ○ |
| C-11 | BalancedAllocationはBestEffort Podをスキップ | E-03 (80-85行目) | ○ |
| C-12 | DRA拡張リソースの委譲判定 | E-01 (241-257行目) | ○ |
| C-13 | IgnoredResources/IgnoredResourceGroupsの除外処理 | E-01 (701-711行目) | ○ |
| C-14 | SidecarContainers（RestartableInitContainer）対応 | E-01 (299-306行目) | ○ |
| C-15 | InPlacePodVerticalScaling対応のイベント登録 | E-01 (334-362行目) | ○ |
| C-16 | CEL式キャッシュの使用 | E-02 (42-49行目, 477-490行目) | ○ |
| C-17 | QueueingHintによる不要な再スケジュール回避 | E-01 (334-362行目) | ○ |
| C-18 | NewFitでバリデーション実施 | E-01 (193-195行目) | ○ |
| C-19 | RequestedToCapacityRatioのbrokenLinearFunction | E-06 (31-58行目) | ○ |
| C-20 | PreFilter/Filter処理はフレームワーク側で並列実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: Filter処理の並列実行はスケジューラーフレームワーク側の実装に依存するため、本プラグインのコードからは直接確認できない
  - 候補：`pkg/scheduler/schedule_one.go` / `pkg/scheduler/framework/runtime/framework.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードからの根拠が十分
- 1: 中リスク - DRA拡張リソース関連の処理は比較的新しい機能であり、仕様変更の可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] フィルタリングロジック（fitsRequest）の記述がソースコードと一致しているか
- [ ] スコアリング計算式が正確か（特にBalancedAllocationの改善度計算）
- [ ] DRA拡張リソース関連の処理フローが正しいか
- [ ] フィーチャーゲートの列挙に漏れがないか
