---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-InterPodAffinityプラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/scheduler/framework/plugins/interpodaffinity/plugin.go`
- E-02: `pkg/scheduler/framework/plugins/interpodaffinity/filtering.go`
- E-03: `pkg/scheduler/framework/plugins/interpodaffinity/scoring.go`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PreFilter/Filter/PreScore/Scoreの4フェーズを実装 | E-01 (39-43行目) | ○ |
| C-02 | 並列処理でAffinityカウントを計算 | E-02 (204-228行目, 234-271行目) | ○ |
| C-03 | satisfyPodAffinityがセルフAffinityを考慮 | E-02 (396-404行目) | ○ |
| C-04 | satisfyPodAntiAffinityがトポロジーペアで判定 | E-02 (367-378行目) | ○ |
| C-05 | satisfyExistingPodsAntiAffinityの実装 | E-02 (352-364行目) | ○ |
| C-06 | NormalizeScoreがMin-Max正規化を使用 | E-03 (258-290行目) | ○ |
| C-07 | IgnorePreferredTermsOfExistingPodsでスキップ可能 | E-03 (146-148行目) | ○ |
| C-08 | HardPodAffinityWeightの考慮 | E-03 (110-113行目) | ○ |
| C-09 | NamespaceSelectorのマージ処理 | E-01 (144-157行目) | ○ |
| C-10 | QueueingHintの実装 | E-01 (83-104行目) | ○ |
| C-11 | PreFilterExtensionsがAddPod/RemovePodを提供 | E-02 (312-334行目) | ○ |
| C-12 | topologyToMatchedTermCountListの最適化 | E-02 (144-184行目) | ○ |
| C-13 | Affinityルール不一致時はUnschedulableAndUnresolvable | E-02 (420行目) | ○ |
| C-14 | Anti-Affinityルール違反時はUnschedulable | E-02 (424行目) | ○ |
| C-15 | Scoreで正値がAffinity、負値がAnti-Affinity | E-03 (239行目コメント) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] セルフAffinity処理の記述がソースコードと一致しているか
- [ ] NormalizeScoreのMin-Max正規化が正確か
- [ ] NamespaceSelectorのマージ処理の記述が正しいか
