---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-TaintTolerationプラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/scheduler/framework/plugins/tainttoleration/taint_toleration.go`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Filter/PreScore/Scoreの3フェーズを実装 | E-01 (41-43行目) | ○ |
| C-02 | FilterでFindMatchingUntoleratedTaintを使用 | E-01 (123-125行目) | ○ |
| C-03 | フィルタ失敗時はUnschedulableAndUnresolvable | E-01 (131行目) | ○ |
| C-04 | PreScoreでPreferNoSchedule Tolerationを抽出 | E-01 (157-164行目) | ○ |
| C-05 | getAllTolerationPreferNoScheduleが空EffectのTolerationも収集 | E-01 (149行目) | ○ |
| C-06 | ScoreでPreferNoSchedule Taintの未許容数をカウント | E-01 (205行目) | ○ |
| C-07 | NormalizeScoreでhelper.DefaultNormalizeScoreを使用 | E-01 (211行目) | ○ |
| C-08 | 逆転正規化（reverse=true） | E-01 (211行目: true引数) | ○ |
| C-09 | QueueingHintでTaint変更時のみ再スケジュール | E-01 (96-116行目) | ○ |
| C-10 | Pod Toleration変更の検知 | E-01 (229-244行目) | ○ |
| C-11 | enableTaintTolerationComparisonOperatorsフラグの存在 | E-01 (38行目) | ○ |
| C-12 | New関数でfeaturesからフラグを取得 | E-01 (220-226行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単一ファイルで完結しており全て根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] DoNotScheduleTaintsFilterFuncの対象Effect（NoSchedule, NoExecute）が正しいか
- [ ] DefaultNormalizeScoreのreverse=trueの動作が正しく説明されているか
