---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：44-VolumeBindingプラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **SchedulerVolumeBinderの内部実装**：binder.goの詳細実装は未読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/scheduler/framework/plugins/volumebinding/volume_binding.go`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 6つの拡張ポイントを実装（PreFilter/Filter/Reserve/PreBind/PreScore/Score） | E-01 (81-88行目) | ○ |
| C-02 | PreFilterでPVCを3カテゴリに分類 | E-01 (369-388行目) | ○ |
| C-03 | PVC未参照の場合はSkip | E-01 (365-368行目) | ○ |
| C-04 | 即時バインド未完了でUnschedulableAndUnresolvable | E-01 (373-380行目) | ○ |
| C-05 | FilterでFindPodVolumesを呼び出し | E-01 (433行目) | ○ |
| C-06 | podVolumesByNodeにMutex保護で保存 | E-01 (448-451行目) | ○ |
| C-07 | ReserveでAssumePodVolumesを呼び出し | E-01 (539行目) | ○ |
| C-08 | PreBindでBindPodVolumesを呼び出し | E-01 (593行目) | ○ |
| C-09 | UnreserveでRevertAssumedPodVolumesを呼び出し | E-01 (614行目) | ○ |
| C-10 | ScoreでstaticBindings/dynamicProvisionsの容量計算 | E-01 (486-520行目) | ○ |
| C-11 | PVCのClaimLost状態チェック | E-01 (340-342行目) | ○ |
| C-12 | PVCのDeletionTimestampチェック | E-01 (344-346行目) | ○ |
| C-13 | Ephemeral VolumeのPod所有者チェック | E-01 (348-352行目) | ○ |
| C-14 | PreBindPreFlightでAllowParallel=true | E-01 (556行目) | ○ |
| C-15 | QueueingHintの多数のイベント登録 | E-01 (107-143行目) | ○ |
| C-16 | SchedulerVolumeBinderの内部バインドロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: binder.goの詳細実装は本分析で読み込んでいないため、FindPodVolumes/AssumePodVolumes/BindPodVolumesの内部ロジックの記述は推論に基づく
  - 候補：`pkg/scheduler/framework/plugins/volumebinding/binder.go`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Binder内部の処理フローは外部インターフェースからの推論

## 6) レビュアーチェックリスト（最小）
- [ ] SchedulerVolumeBinderの内部実装がドキュメントの記述と整合しているか
- [ ] StorageCapacityScoringのShape関数の動作が正しいか
- [ ] QueueingHintのイベント条件が網羅されているか
