---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：45-PodTopologySpreadプラグイン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Filter/Scoreのコアロジック**: filtering.go/scoring.goの詳細実装は未読み込み

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/scheduler/framework/plugins/podtopologyspread/plugin.go`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PreFilter/Filter/PreScore/Scoreの4フェーズを実装 | E-01 (75-79行目) | ○ |
| C-02 | SystemDefault制約: hostname MaxSkew=3, zone MaxSkew=5 | E-01 (46-57行目) | ○ |
| C-03 | SystemDefaultはScheduleAnyway | E-01 (49行目, 51行目) | ○ |
| C-04 | SignPodでTopologySpreadConstraints持ちPodは対象外 | E-01 (93-103行目) | ○ |
| C-05 | New関数でSystemDefaulting判定 | E-01 (126-129行目) | ○ |
| C-06 | デフォルト制約時にLister設定 | E-01 (130-135行目) | ○ |
| C-07 | Pod/Node両方のQueueingHintを実装 | E-01 (156-183行目) | ○ |
| C-08 | Pod変更時はラベルマッチを検証 | E-01 (232-244行目) | ○ |
| C-09 | Node変更時はトポロジーキーラベルの存在を検証 | E-01 (302-362行目) | ○ |
| C-10 | NodeTaintsPolicy=Honor時のToleration変更検知 | E-01 (224-229行目) | ○ |
| C-11 | getConstraints でPod制約とデフォルト制約を切替 | E-01 (278-299行目) | ○ |
| C-12 | checkTopologyKeyLabelsChanged でラベル値変更を検出 | E-01 (365-373行目) | ○ |
| C-13 | involvedInTopologySpreading でNamespace一致を検証 | E-01 (186-194行目) | ○ |
| C-14 | Filter/ScoreのMaxSkew計算ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: filtering.go/scoring.goの詳細実装を読み込んでいないため、具体的なMaxSkew計算ロジックの記述は推論に基づく
  - 候補：`pkg/scheduler/framework/plugins/podtopologyspread/filtering.go` / `scoring.go`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Filter/Scoreの詳細ロジックは推論ベース

## 6) レビュアーチェックリスト（最小）
- [ ] MaxSkew計算ロジックがfiltering.goの実装と一致しているか
- [ ] SystemDefault制約の値が正確か
- [ ] NodeInclusionPolicyの動作がfiltering.goと一致しているか
