---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：5-API拡張（CRD/Aggregation）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **CRD v1でstructural schema必須**：バージョン固有の仕様確認
  2. **CRD登録後API利用開始が数秒以内**：パフォーマンス要件の根拠

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/apiextensions-apiserver/pkg/` ディレクトリ構造
- E-02: `staging/src/k8s.io/kube-aggregator/` ディレクトリ構造
- E-03: `cmd/kube-apiserver/app/aggregator.go` - Aggregator初期化
- E-04: `cmd/kube-apiserver/app/server.go` 56行目 - aggregatorapiserver import
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.5の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CRDによるカスタムリソース定義とAPI Aggregationによる拡張APIサーバー統合 | E-05 | ○ |
| C-02 | apiextensions-apiserverがCRD処理を担当 | E-01 | ○ |
| C-03 | kube-aggregatorがAPI Aggregationを担当 | E-02 | ○ |
| C-04 | aggregator.goでkube-apiserver内に統合 | E-03, E-04 | ○ |
| C-05 | CRDコントローラーが存在 | E-01 | ○ |
| C-06 | CRDレジストリが存在 | E-01 | ○ |
| C-07 | apiextensions-apiserverがカスタムリソースハンドラを動的生成 | E-01 | ○ |
| C-08 | APIServiceに基づくプロキシルート設定 | E-02 | ○ |
| C-09 | Conversion WebhookによるCRDバージョン変換 | E-05 | ○ |
| C-10 | カスタムリソースのサブリソース（status, scale）サポート | E-05 | ○ |
| C-11 | CRDはCluster scoped | E-05 | ○ |
| C-12 | CRD作成はcluster-admin権限が必要 | E-05 | ○ |
| C-13 | apiextensions-apiserverは独立バイナリとしても動作可能 | E-01 | ○ |
| C-14 | etcdにカスタムリソースが永続化 | E-05 | ○ |
| C-15 | CRD v1でstructural schemaが必須 | **根拠なし** | △ |
| C-16 | CRD登録後のAPI利用開始が数秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- structural schema必須化はapiextensions-apiserver内のバリデーションロジックで確認すべき
  - 候補：`staging/src/k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/validation/`
- CRD登録後のAPI利用開始時間はEstablishingコントローラーの実装から確認
  - 候補：`staging/src/k8s.io/apiextensions-apiserver/pkg/controller/establish/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ディレクトリ構造はソースコードと一致
- 1: 中リスク - structural schema必須化の詳細仕様の確認が必要
- 0: 低リスク - Aggregator初期化コードは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CRD v1のstructural schema必須化がバリデーションコードと一致しているか確認
- [ ] API Aggregationのプロキシハンドラの動作を確認
- [ ] CRD Establishing後のAPI利用開始タイミングを確認
