---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：51-イメージ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：Kubelet設定ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/images/types.go` - ImageManagerインターフェース定義
- E-02: `pkg/kubelet/images/image_manager.go` - imageManager構造体とEnsureImageExists実装
- E-03: `pkg/kubelet/images/image_gc_manager.go` - ImageGCManager、GCポリシー、detectImages、GarbageCollect
- E-04: `pkg/kubelet/images/puller.go` - parallelImagePuller/serialImagePuller実装
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.51の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ImageManagerインターフェースはEnsureImageExistsメソッドを持つ | E-01 (49-52行目) | ○ |
| C-02 | pullPolicyはAlways/IfNotPresent/Neverの3種類 | E-02 (117-127行目) | ○ |
| C-03 | デフォルトタグ適用はapplyDefaultImageTag関数で実施 | E-02 (417-432行目) | ○ |
| C-04 | 直列/並列プーラーの選択はserializedパラメータで制御 | E-02 (91-95行目) | ○ |
| C-05 | 並列プーラーはトークンベースの並列数制御を実装 | E-04 (48-53行目, 57-60行目) | ○ |
| C-06 | シリアルプーラーのキュー最大サイズは10 | E-04 (79行目) | ○ |
| C-07 | バックオフはpodUID_imageキーで管理 | E-02 (336行目) | ○ |
| C-08 | GCポリシーのHighThresholdPercentは0-100の範囲 | E-03 (193-194行目) | ○ |
| C-09 | LowThresholdPercentはHighThresholdPercent以下 | E-03 (199-201行目) | ○ |
| C-10 | イメージ検出は5分間隔 | E-03 (224行目) | ○ |
| C-11 | イメージキャッシュ更新は30秒間隔 | E-03 (234行目) | ○ |
| C-12 | GC削除順序はlastUsed、firstDetectedの順 | E-03 (646-652行目) | ○ |
| C-13 | pinned イメージはGC対象外 | E-03 (567-570行目) | ○ |
| C-14 | KubeletEnsureSecretPulledImages機能による認証検証 | E-02 (243-265行目) | ○ |
| C-15 | イメージ不在とアクセス拒否で同一エラーメッセージ | E-02 (148-160行目コメント) | ○ |
| C-16 | MaxAgeはKubelet起動後MaxAge経過するまで適用されない | E-03 (432-434行目) | ○ |
| C-17 | RuntimeClassInImageCriAPI有効時はタプルで管理 | E-03 (624-629行目) | ○ |
| C-18 | レート制限QPS/Burstパラメータの具体的デフォルト値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レート制限QPS/Burstの具体的なデフォルト値はKubelet設定コードに記載されており、images パッケージ内では確認できない
  - 候補：`cmd/kubelet/app/options/` / `pkg/kubelet/apis/config/` / Kubelet設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性は高い
- 1: 中リスク - KubeletEnsureSecretPulledImagesは比較的新しい機能であり、動作確認が推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] エラー処理のCRIエラー分類が実際のランタイム動作と合致するか確認
- [ ] KubeletEnsureSecretPulledImages有効時の動作シーケンスが正確か確認
- [ ] GCポリシーのデフォルト値がKubelet設定と一致するか確認
