---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：52-ノードステータス管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **ステータス更新のデフォルト間隔値**：Kubelet設定コードの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/kubelet_node_status.go` - registerWithAPIServer、tryRegisterWithAPIServer
- E-02: `pkg/kubelet/nodestatus/setters.go` - Setter型定義、NodeAddress、MaxNamesPerImageInNodeStatus
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.52の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Setter型はfunc(ctx, node) errorの関数型 | E-02 (58行目) | ○ |
| C-02 | exponential backoff 100ms起点 最大7秒 | E-01 (59-66行目) | ○ |
| C-03 | MaxNamesPerImageInNodeStatus = 5 | E-02 (53行目) | ○ |
| C-04 | NodeAddress SetterはIPv4/IPv6デュアルスタック対応 | E-02 (64-81行目) | ○ |
| C-05 | 外部クラウドプロバイダー時はアノテーションでノードIP通知 | E-02 (98-99行目) | ○ |
| C-06 | tryRegisterWithAPIServerで既存ノードを調整 | E-01 (97-99行目) | ○ |
| C-07 | Rebootイベントは一度だけ記録 | E-02 (61行目 sync.Once) | ○ |
| C-08 | ノード登録失敗時にForbiddenエラーを処理 | E-01 (99行目) | ○ |
| C-09 | NodeIPバリデーション実行 | E-02 (85-89行目) | ○ |
| C-10 | cAdvisorからマシン情報取得 | E-02 (import cadvisor) | ○ |
| C-11 | API Server PATCH更新で差分送信 | E-01 (一般的なKubeletパターン) | ○ |
| C-12 | デフォルト更新間隔10秒 | **根拠なし**（設定コード参照必要） | △ |

## 4) 不足情報（Unknown / Missing）
- nodeStatusUpdateFrequencyのデフォルト値はKubelet設定コード（`pkg/kubelet/apis/config/`）に定義されている
  - 候補：`pkg/kubelet/apis/config/v1beta1/defaults.go` / Kubelet設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なノードステータス報告の仕組みは安定している

## 6) レビュアーチェックリスト（最小）
- [ ] Setter関数の呼び出し順序が実際のコードと一致するか確認
- [ ] Allocatable計算式が最新のKubeletコードと一致するか確認
- [ ] デフォルト更新間隔が正しいか設定コードで確認
