---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-ヘルスチェック（Probe）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/prober/prober_manager.go` - Managerインターフェース、manager構造体
- E-02: `pkg/kubelet/prober/prober.go` - prober構造体、probe()メソッド、maxProbeRetries
- E-03: `pkg/kubelet/prober/worker.go` - worker構造体、プローブループ
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.53の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Managerインターフェースは AddPod/RemovePod/UpdatePodStatus を持つ | E-01 (75-94行目) | ○ |
| C-02 | prober構造体はexec/http/tcp/grpcの4プローバーを持つ | E-02 (44-49行目) | ○ |
| C-03 | maxProbeRetries = 3 | E-02 (41行目) | ○ |
| C-04 | followNonLocalRedirects = false | E-02 (60行目) | ○ |
| C-05 | worker構造体はprobeType、initialValue、resultsManager等を持つ | E-03 (39-63行目) | ○ |
| C-06 | workerはstopChとmanualTriggerChチャネルを持つ | E-03 (41-44行目) | ○ |
| C-07 | probe()はprobeTypeに基づきreadiness/liveness/startupを選択 | E-02 (83-94行目) | ○ |
| C-08 | ProberResults メトリクスはprobe_type/result/container/pod/namespace/pod_uidラベル | E-01 (42-55行目) | ○ |
| C-09 | ProberDuration メトリクスはprobe_type/container/pod/namespaceラベル | E-01 (58-69行目) | ○ |
| C-10 | Managerはworkers mapをworkerLockで保護 | E-01 (96-100行目) | ○ |
| C-11 | StopLivenessAndStartupメソッドが存在 | E-01 (81行目) | ○ |
| C-12 | CleanupPodsメソッドが存在 | E-01 (89行目) | ○ |
| C-13 | proberはrecord.EventRecorderを使用 | E-02 (51行目) | ○ |
| C-14 | 3種類のプローブ結果（Success/Failure/Unknown） | E-02 (results パッケージ) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プローブ機能はKubernetesの安定した機能であり、ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] worker.doProbe()の詳細な状態遷移ロジックが正確か確認
- [ ] Startup Probe完了時のLiveness/Readiness開始タイミングが正確か確認
