---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：59-ノードシャットダウン管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/nodeshutdown/nodeshutdown_manager.go` - Managerインターフェース、Config、podManager
- E-02: `pkg/kubelet/nodeshutdown/nodeshutdown_manager_linux.go` - managerImpl、NewManager
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.59の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Managerインターフェースは Admit/Start/ShutdownStatus | E-01 (41-47行目) | ○ |
| C-02 | NodeShutdownNotAdmittedReason = "NodeShutdown" | E-01 (84行目) | ○ |
| C-03 | nodeShutdownReason = "Terminated" | E-01 (88行目) | ○ |
| C-04 | nodeShutdownMessage = "Pod was terminated in response to imminent node shutdown." | E-01 (89行目) | ○ |
| C-05 | localStorageStateFile = "graceful_node_shutdown_state" | E-01 (86行目) | ○ |
| C-06 | podManager構造体はshutdownGracePeriodByPodPriority等を持つ | E-01 (93-99行目) | ○ |
| C-07 | killPodsは優先度グループごとに段階的に終了 | E-01 (129-219行目) | ○ |
| C-08 | Pod猶予期間はgroupのShutdownGracePeriodSecondsとPodのTerminationGracePeriodSecondsの小さい方 | E-01 (147-149行目) | ○ |
| C-09 | WaitForAllPodsUnmount()でボリュームアンマウント待機 | E-01 (191行目) | ○ |
| C-10 | DisruptionTarget Pod Conditionの設定 | E-01 (160-166行目) | ○ |
| C-11 | groupByPriorityでPodを優先度グループに分類 | E-01 (258-294行目) | ○ |
| C-12 | dbusReconnectPeriod = 1秒 | E-02 (42行目) | ○ |
| C-13 | GracefulNodeShutdownフィーチャーゲートで有効/無効制御 | E-02 (80行目) | ○ |
| C-14 | migrateConfigで旧設定からの移行 | E-01 (229-251行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] Linux実装のStart()メソッドのD-Bus監視ロジックの詳細を確認
- [ ] Windows実装の動作を確認
- [ ] InhibitDelayの設定とOverrideInhibitDelayの動作を確認
