---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：6-OpenAPI仕様公開

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **Protobuf形式のサポート詳細**：Accept Headerの正確な形式確認
  2. **ETag対応の詳細実装**：キャッシュ検証メカニズムの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `api/openapi-spec/` ディレクトリ構造 - swagger.json, v3/の存在確認
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.6の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - kubectl explainとの関連
- E-04: `api/openapi-spec/README.md` の存在確認

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenAPI v2/v3仕様を自動生成して公開 | E-02 | ○ |
| C-02 | api/openapi-spec/にswagger.jsonが存在 | E-01 | ○ |
| C-03 | api/openapi-spec/v3/にOpenAPI v3仕様が存在 | E-01 | ○ |
| C-04 | kubectl explainがOpenAPI仕様を参照 | E-03 | ○ |
| C-05 | /openapi/v2と/openapi/v3エンドポイントで提供 | E-02 | ○ |
| C-06 | CRDのスキーマがOpenAPI仕様に統合される | E-02 | ○ |
| C-07 | 拡張APIサーバーのスキーマが統合される | E-02 | ○ |
| C-08 | OpenAPI v3仕様はグループ/バージョン単位で分割 | E-01 | ○ |
| C-09 | API Server内のレジストリ情報から仕様生成 | E-02 | ○ |
| C-10 | 仕様キャッシュによる高速応答 | E-02 | ○ |
| C-11 | CRD変更時の自動仕様更新 | E-02 | ○ |
| C-12 | README.mdが存在 | E-04 | ○ |
| C-13 | Protobuf形式での仕様提供 | **根拠なし** | △ |
| C-14 | ETagによるキャッシュ検証対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Protobuf形式のサポートはapiserver内のOpenAPIハンドラから確認すべき
  - 候補：`staging/src/k8s.io/apiserver/pkg/endpoints/openapi/` のハンドラ実装
- ETag対応の実装はOpenAPIサービスのHTTPハンドラから確認
  - 候補：`staging/src/k8s.io/apiserver/pkg/server/` のOpenAPIハンドラ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ファイル構造はソースコードと一致
- 1: 中リスク - Protobuf/ETag対応の詳細実装の確認が必要
- 0: 低リスク - 画面マッピングはCSVデータと一致

## 6) レビュアーチェックリスト（最小）
- [ ] /openapi/v2と/openapi/v3エンドポイントの実際の動作を確認
- [ ] Protobuf形式のAccept Headerが正しいか確認
- [ ] ETag対応の実装詳細を確認
