---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：64-証明書管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **certificate.Managerの内部リトライロジック**：client-goパッケージ内の実装詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/certificate/kubelet.go` - 証明書管理実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CSR SubjectはCommonName=system:node:＜nodeName＞ | E-01 (63-65行目, 231-234行目) | ○ |
| C-02 | Organization=system:nodes | E-01 (65行目, 234行目) | ○ |
| C-03 | サーバー証明書はKubeletServingSignerNameで署名 | E-01 (128行目) | ○ |
| C-04 | クライアント証明書はKubeAPIServerClientKubeletSignerNameで署名 | E-01 (237行目) | ○ |
| C-05 | AllowDNSOnlyNodeCSRフィーチャーゲートでDNSのみCSR可能 | E-01 (54-56行目) | ○ |
| C-06 | IPアドレスがない場合はCSRテンプレートを返さない（デフォルト） | E-01 (59-61行目) | ○ |
| C-07 | TTLメトリクスはmath.Inf(1)を返す（証明書未設定時） | E-01 (152行目) | ○ |
| C-08 | FileStoreで証明書を永続化する | E-01 (82-88行目) | ○ |
| C-09 | DynamicFileManagerはファイル変更を検出してリロードする | E-01 (284-296行目) | ○ |
| C-10 | DynamicFileManagerはAPI Server通信なしで動作する | E-01 (320-322行目) | ○ |
| C-11 | ブートストラップ証明書がクライアント証明書の初期データとして使用可能 | E-01 (240-243行目) | ○ |
| C-12 | server_expiration_renew_errorsカウンターが登録される | E-01 (91-99行目) | ○ |
| C-13 | certificate_manager_server_rotation_secondsヒストグラムが登録される | E-01 (101-121行目) | ○ |
| C-14 | certificate.Managerのリトライがexponential backoff | **根拠なし** (client-goパッケージ内実装) | △ |

## 4) 不足情報（Unknown / Missing）
- certificate.Manager（client-go）の内部リトライロジックの詳細
  - 候補: `staging/src/k8s.io/client-go/util/certificate/certificate_manager.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 証明書管理の主要ロジックは確認済み
- 1: 中リスク - 内部リトライロジックはclient-goに依存

## 6) レビュアーチェックリスト（最小）
- [ ] CSRテンプレートに含まれるDNS名/IPアドレスの正確性を確認
- [ ] 証明書ローテーションのタイミング（有効期限の何%で更新開始か）を確認
- [ ] ブートストラップ証明書の権限が適切に制限されているか確認
